QT += testlib \
    xml \
    network
TEMPLATE = app
CONFIG += qtestlib
CONFIG += link_pkgconfig
PKGCONFIG += libalarm

INCLUDEPATH += ../src/Domain/ \
    ../src/Domain/Configuration/ \
    ../src/IO/ \
    ../src/IO/Communication/ \
    ../src/IO/DeviceControl/ \
    ../src/BusinessLogic/ \
    ../src/BusinessLogic/Utils/ \
    ../src/UserInterface/ \
    ../src/UserInterface/Components/ \
    ../src/UserInterface/Utils/ \
    ../src/UserInterface/Views/ \
    Domain/Room/ \
    Domain/Meeting/ \
    Domain/Configuration/ConnectionSettings/ \
    Domain/Configuration/DisplaySettings/ \
    Domain/Configuration/StartupSettings/ \
    Domain/Configuration/Configuration/ \
    BusinessLogic/Utils/Clock/ \
    BusinessLogic/Utils/ErrorMapper/ \
    BusinessLogic/Engine/ \
    UserInterface/Components/MeetingRoomCombo/

HEADERS += ../src/Domain/Room.h \
    ../src/Domain/Meeting.h \
    ../src/Domain/Configuration/ConnectionSettings.h \
    ../src/Domain/Configuration/StartupSettings.h \
    ../src/Domain/Configuration/DisplaySettings.h \
    ../src/Domain/Configuration/Configuration.h \
    ../src/IO/Communication/Communication.h \
    ../src/IO/Communication/CommunicationManager.h \
    ../src/IO/DeviceControl/AlarmSender.h \
    ../src/IO/DeviceControl/HWKeyListener.h \
    ../src/IO/DeviceControl/DeviceDataStorage.h \
    ../src/IO/DeviceControl/DeviceManager.h \
    ../src/BusinessLogic/Utils/ErrorMapper.h \
    ../src/BusinessLogic/Utils/Clock.h \
    ../src/BusinessLogic/Engine.h \
    ../src/UserInterface/Utils/ToolBox.h \
    ../src/UserInterface/Utils/PopUpMessageBox.h \
    ../src/UserInterface/Components/ObservedWidget.h \
    ../src/UserInterface/Components/TimeDisplayWidget.h \
    ../src/UserInterface/Components/DigitalTimeDisplayWidget.h \
    ../src/UserInterface/Components/MeetingRoomCombo.h \
    ../src/UserInterface/Components/ScheduleWidget.h \
    ../src/UserInterface/Views/RoomStatusIndicatorWidget.h \
    ../src/UserInterface/Views/WeeklyViewWidget.h \
    ../src/UserInterface/Views/MeetingInfoDialog.h \
    ../src/UserInterface/WindowManager.h \
    Domain/Room/TestRoom.h \
    Domain/Meeting/TestMeeting.h \
    Domain/Configuration/ConnectionSettings/TestConnectionSettings.h \
    Domain/Configuration/DisplaySettings/TestDisplaySettings.h \
    Domain/Configuration/StartupSettings/TestStartupSettings.h \
    Domain/Configuration/Configuration/TestConfiguration.h \
    BusinessLogic/Utils/Clock/TestClock.h \
    BusinessLogic/Utils/ErrorMapper/TestErrorMapper.h \
    BusinessLogic/Engine/TestEngine.h \
    UserInterface/Components/MeetingRoomCombo/TestMeetingRoomCombo.h

SOURCES += ../src/Domain/Room.cpp \
    ../src/Domain/Meeting.cpp \
    ../src/Domain/Configuration/ConnectionSettings.cpp \
    ../src/Domain/Configuration/StartupSettings.cpp \
    ../src/Domain/Configuration/DisplaySettings.cpp \
    ../src/Domain/Configuration/Configuration.cpp \
    ../src/IO/Communication/Communication.cpp \
    ../src/IO/Communication/CommunicationManager.cpp \
    ../src/IO/DeviceControl/AlarmSender.cpp \
    ../src/IO/DeviceControl/HWKeyListener.cpp \
    ../src/IO/DeviceControl/DeviceDataStorage.cpp \
    ../src/IO/DeviceControl/DeviceManager.cpp \
    ../src/BusinessLogic/Utils/ErrorMapper.cpp \
    ../src/BusinessLogic/Utils/Clock.cpp \
    ../src/BusinessLogic/Engine.cpp \
    ../src/UserInterface/Utils/ToolBox.cpp \
    ../src/UserInterface/Utils/PopUpMessageBox.cpp \
    ../src/UserInterface/Components/ObservedWidget.cpp \
    ../src/UserInterface/Components/TimeDisplayWidget.cpp \
    ../src/UserInterface/Components/DigitalTimeDisplayWidget.cpp \
    ../src/UserInterface/Components/MeetingRoomCombo.cpp \
    ../src/UserInterface/Components/ScheduleWidget.cpp \
    ../src/UserInterface/Views/RoomStatusIndicatorWidget.cpp \
    ../src/UserInterface/Views/WeeklyViewWidget.cpp \
    ../src/UserInterface/Views/MeetingInfoDialog.cpp \
    ../src/UserInterface/WindowManager.cpp \
    Domain/Room/TestRoom.cpp \
    Domain/Meeting/TestMeeting.cpp \
    Domain/Configuration/ConnectionSettings/TestConnectionSettings.cpp \
    Domain/Configuration/DisplaySettings/TestDisplaySettings.cpp \
    Domain/Configuration/StartupSettings/TestStartupSettings.cpp \
    Domain/Configuration/Configuration/TestConfiguration.cpp \
    BusinessLogic/Utils/Clock/TestClock.cpp \
    BusinessLogic/Utils/ErrorMapper/TestErrorMapper.cpp \
    BusinessLogic/Engine/TestEngine.cpp \
    UserInterface/Components/MeetingRoomCombo/TestMeetingRoomCombo.cpp \
    TestQtMeetings.cpp

RESOURCES += ../resources/BusinessLogic.qrc \
    ../resources/UserInterface.qrc
