#include <QtTest/QtTest>
#include <QApplication>

// Domain
#include "TestRoom.h"
#include "TestMeeting.h"
#include "TestConnectionSettings.h"
#include "TestDisplaySettings.h"
#include "TestStartupSettings.h"
#include "TestConfiguration.h"

// Communication
// TODO : includes here

// DeviceControl
// TODO : includes here

// BusinessLogic
#include "TestClock.h"
#include "TestErrorMapper.h"
#include "TestEngine.h"

// UserInterface
#include "TestMeetingRoomCombo.h"

int main( int argc, char *argv[] )
{
	QApplication app( argc, argv );

	/************ Domain ************/
	TestRoom testRoom;
	QTest::qExec( &testRoom );

	TestMeeting testMeeting;
	QTest::qExec( &testMeeting );

	TestConnectionSettings testConnectionSettings;
	QTest::qExec( &testConnectionSettings );

	TestDisplaySettings testDisplaySettings;
	QTest::qExec( &testDisplaySettings );

	TestStartupSettings testStartupSettings;
	QTest::qExec( &testStartupSettings );

	TestConfiguration testConfiguration;
	QTest::qExec( &testConfiguration );

	/************ Communication ************/
	// TODO : tests here

	/************ DeviceControl ************/
	// TODO : tests here

	/************ BusinessLogic ************/
	TestClock testClock;
	QTest::qExec( &testClock );

	TestErrorMapper testErrorMapper;
	QTest::qExec( &testErrorMapper );

	TestEngine testEngine;
	// TODO : TestEngine ends up in Segmentation fault for some reason if run together with other tests. Individually everything goes OK.
//	QTest::qExec( &testEngine );

	/************ UserInterface ************/
	TestMeetingRoomCombo testMeetingRoomCombo;
	QTest::qExec( &testMeetingRoomCombo );
}
