#include <QtTest/QtTest>

#include "Room.h"
#include "TestRoom.h"

void TestRoom::initTestCase()
{
	iName1 = "myName";
	iName2 = "otherName";
	iAddress1 = "myAddress";
	iAddress2 = "otherAddress";

	iRoom1 = new Room( iName1, iAddress1 );
	iRoom2 = new Room( iName1, iAddress2 );
	iRoom3 = new Room( iName2, iAddress1 );
	iRoom4 = new Room( iName2, iAddress2 );

	QVERIFY( iRoom1 != 0 );
	QVERIFY( iRoom2 != 0 );
	QVERIFY( iRoom2 != 0 );
	QVERIFY( iRoom4 != 0 );
}

void TestRoom::cleanupTestCase()
{
	delete iRoom1;
	iRoom1 = 0;
	delete iRoom2;
	iRoom2 = 0;
	delete iRoom2;
	iRoom2 = 0;
	delete iRoom4;
	iRoom4 = 0;
}

void TestRoom::init()
{
	//qDebug("Debug line");
}

void TestRoom::cleanup()
{
	//nothing to do
}

void TestRoom::testName()
{
	QCOMPARE( iRoom1->name(), iName1 );
}

void TestRoom::testAddress()
{
	QCOMPARE( iRoom1->address(), iAddress1 );
}

void TestRoom::testEquals()
{
	QCOMPARE( iRoom1->equals( iRoom1 ), true );
	QCOMPARE( iRoom1->equals( iRoom2 ), false );
	QCOMPARE( iRoom1->equals( iRoom3 ), false );
	QCOMPARE( iRoom1->equals( iRoom4 ), false );
}

void TestRoom::testToString()
{
	QString room1ToString = QString( "[Room: name:%1 address:%2 ]" )
					.arg( iName1 )
					.arg( iAddress1 );

	QCOMPARE( iRoom1->toString(), room1ToString );
}
