#include <QObject>
#include <QDateTime>

class Meeting;
class Room;

class TestMeeting: public QObject
{
	Q_OBJECT

private slots:
	void initTestCase();
	void init();
	void cleanup();
	void testPrimaryId();
	void testSecondaryId();
	void testGetAndSetOrganizer();
	void testStartsAt();
	void testEndsAt();
	void testSubject();
	void testDescription();
	void testDetailsAvailable();
	void testSetSecondaryId();
	void testSetStartsAt();
	void testSetEndsAt();
	void testSetSubject();
	void testSetDescription();
	void testEquals();
	void testToString();
	void cleanupTestCase();

private:
	Meeting *iMeeting1, *iMeeting2;

	int iPrimaryId1, iPrimaryId2;
	int iSecondaryId1, iSecondaryId2;
	Room *iRoom;
	QString iOrganizer1Name, iOrganizer1EMail;
	QString iOrganizer2Name, iOrganizer2EMail;
	QDateTime iStartsAt1, iStartsAt2;
	QDateTime iEndsAt1, iEndsAt2;
	QString iSubject1, iSubject2;
	QString iDescription1, iDescription2;

};
