#include <QtTest/QtTest>
#include "Meeting.h"
#include "Room.h"
#include "TestMeeting.h"

void TestMeeting::initTestCase()
{
	iPrimaryId1 = 5;
	iPrimaryId2 = 0xa6c8eef1;
	iSecondaryId1 = 0;
	iSecondaryId2 = 0xFFFF0005;

	iRoom = new Room( "Pegasus", "meetingroom.pegasus_jyv@ixonos.com" );
	QVERIFY( iRoom != 0 );

	iOrganizer1Name = "Test Organizer";
	iOrganizer1EMail = "test.organizer@company.url";
	iOrganizer2EMail = "Another Organizer";
	iOrganizer2Name = "another.organizer@company.url";

	iStartsAt1 = QDateTime( QDate( 2007, 3, 13 ), QTime( 13, 0, 0 ) );
	iStartsAt2 = QDateTime( QDate( 2007, 3, 14 ), QTime( 13, 0, 0 ) );

	iEndsAt1 = QDateTime( QDate( 2007, 3, 13 ), QTime( 14, 0, 0 ) );
	iEndsAt2 = QDateTime( QDate( 2007, 3, 14 ), QTime( 14, 0, 0 ) );

	iSubject1 = "Test subject";
	iSubject2 = "Another subject";

	iDescription1 = "This is a description. This is actually a plain text description, not as is was important at all.";
	iDescription2 = "<p>This is a description. This is actually a <b>HTML<//b> text description, <i>not as is was important at all.<//i><//p>";

	iMeeting1 = new Meeting( iPrimaryId1, iRoom, iStartsAt1, iEndsAt1, iOrganizer1Name, iOrganizer1EMail, iSubject1 );
	QVERIFY( iMeeting1 != 0 );

	iMeeting2 = new Meeting( iPrimaryId1, iRoom, iStartsAt1, iEndsAt1, "", "", iSubject1, iDescription2 );
	QVERIFY( iMeeting2 != 0 );
}

void TestMeeting::cleanupTestCase()
{
	delete iMeeting1;
	iMeeting1 = NULL;
	delete iMeeting2;
	iMeeting2 = NULL;
	delete iRoom;
	iRoom = NULL;
}

void TestMeeting::init()
{
	//qDebug("Debug line");
}

void TestMeeting::cleanup()
{
	//nothing to do
}

void TestMeeting::testPrimaryId()
{
	QCOMPARE( iMeeting1->primaryId(), iPrimaryId1 );
	QCOMPARE( iMeeting2->primaryId(), iPrimaryId1 );
}

void TestMeeting::testSecondaryId()
{
	iMeeting1->setSecondaryId( iSecondaryId1 );
	QCOMPARE( iMeeting1->secondaryId(), iSecondaryId1 );
	QCOMPARE( iMeeting2->secondaryId(), 0 );
}

void TestMeeting::testGetAndSetOrganizer()
{
	QCOMPARE( iMeeting2->organizer(), QString( "" ) );

	iMeeting2->setOrganizer( iOrganizer2Name, "" );
	QCOMPARE( iMeeting2->organizer(), iOrganizer2Name );

	iMeeting2->setOrganizer( "", iOrganizer2EMail );
	QCOMPARE( iMeeting2->organizer(), iOrganizer2EMail );

	iMeeting2->setOrganizer( iOrganizer2Name, iOrganizer2EMail );
	QCOMPARE( iMeeting2->organizer(), QString( "%1 <%2>" ).arg( iOrganizer2Name ).arg( iOrganizer2EMail ) );
}

void TestMeeting::testStartsAt()
{
	QCOMPARE( iMeeting1->startsAt(), iStartsAt1 );
}

void TestMeeting::testEndsAt()
{
	QCOMPARE( iMeeting1->endsAt(), iEndsAt1 );
}

void TestMeeting::testSubject()
{
	QCOMPARE( iMeeting1->subject(), iSubject1 );
}

void TestMeeting::testDescription()
{
	QCOMPARE( iMeeting1->description(), QString( "" ) );
	QCOMPARE( iMeeting2->description(), iDescription2 );
}

void TestMeeting::testDetailsAvailable()
{
	QCOMPARE( iMeeting1->detailsAvailable(), true );
	QCOMPARE( iMeeting2->detailsAvailable(), false );
}

void TestMeeting::testSetSecondaryId()
{
	iMeeting1->setSecondaryId( -1 );
	QCOMPARE( iMeeting1->secondaryId(), -1 );

	iMeeting1->setSecondaryId( iSecondaryId1 );
	QCOMPARE( iMeeting1->secondaryId(), iSecondaryId1 );

	iMeeting2->setSecondaryId( iSecondaryId2 );
	QCOMPARE( iMeeting2->secondaryId(), iSecondaryId2 );
}

void TestMeeting::testSetStartsAt()
{
	iMeeting1->setStartsAt( iStartsAt2 );
	QCOMPARE( iMeeting1->startsAt(), iStartsAt2 );

	iMeeting1->setStartsAt( iStartsAt1 );
	QCOMPARE( iMeeting1->startsAt(), iStartsAt1 );
}

void TestMeeting::testSetEndsAt()
{
	iMeeting1->setEndsAt( iEndsAt2 );
	QCOMPARE( iMeeting1->endsAt(), iEndsAt2 );

	iMeeting1->setEndsAt( iEndsAt1 );
	QCOMPARE( iMeeting1->endsAt(), iEndsAt1 );
}

void TestMeeting::testSetSubject()
{
	iMeeting1->setSubject( iSubject2 );
	QCOMPARE( iMeeting1->subject(), iSubject2 );

	iMeeting1->setSubject( iSubject1 );
	QCOMPARE( iMeeting1->subject(), iSubject1 );
}

void TestMeeting::testSetDescription()
{
	iMeeting1->setDescription( iDescription1 );
	QCOMPARE( iMeeting1->description(), iDescription1 );

	iMeeting2->setDescription( iDescription2 );
	QCOMPARE( iMeeting2->description(), iDescription2 );
}

void TestMeeting::testEquals()
{
	iMeeting2->setEndsAt( iEndsAt2 );
	QCOMPARE( iMeeting1->equals( iMeeting2 ), false );

	iMeeting2->setEndsAt( iEndsAt1 );
	QCOMPARE( iMeeting1->equals( iMeeting2 ), true );
}

void TestMeeting::testToString()
{
	QString meeting1ToString = QString( "[MEETING: id1:%1 id2:%2 in:%3 from:%4 until:%5 by:%6 subject:%7 description:%8]" )
					   .arg( iPrimaryId1 )
					   .arg( iSecondaryId1 )
					   .arg( iRoom->toString() )
					   .arg( iStartsAt1.toString() )
					   .arg( iEndsAt1.toString() )
					   .arg( iMeeting1->organizer() )
					   .arg( iSubject1 )
					   .arg( iDescription1 );

	QCOMPARE( iMeeting1->toString(), meeting1ToString );
}
