#include <QtTest/QtTest>
#include <QDateTime>
#include "StartupSettings.h"
#include "TestStartupSettings.h"

const QTime TIME_0800 = QTime( 8, 00 );
const QTime TIME_0845 = QTime( 8, 45 );
const QTime TIME_1700 = QTime( 17, 00 );
const QTime TIME_1710 = QTime( 17, 10 );

void TestStartupSettings::initTestCase()
{
	iSettings_f_800_1700 = new StartupSettings( false, TIME_0800, TIME_1700 );
	iSettings_t_845_1710 = new StartupSettings( true, TIME_0845, TIME_1710 );

	QVERIFY( iSettings_f_800_1700 != 0 );
	QVERIFY( iSettings_t_845_1710 != 0 );
}

void TestStartupSettings::cleanupTestCase()
{
	delete iSettings_f_800_1700;
	iSettings_f_800_1700 = 0;

	delete iSettings_t_845_1710;
	iSettings_t_845_1710 = 0;
}

void TestStartupSettings::init()
{
	//qDebug("Debug line");
}

void TestStartupSettings::cleanup()
{
	//nothing to do
}

void TestStartupSettings::testIsPowersavingEnabled()
{
	QCOMPARE( iSettings_f_800_1700->isPowersavingEnabled(), false );
	QCOMPARE( iSettings_t_845_1710->isPowersavingEnabled(), true );
}

void TestStartupSettings::testTurnOnAt()
{
	QCOMPARE( iSettings_f_800_1700->turnOnAt(), TIME_0800 );
	QCOMPARE( iSettings_t_845_1710->turnOnAt(), TIME_0845 );
}

void TestStartupSettings::testTurnOffAt()
{
	QCOMPARE( iSettings_f_800_1700->turnOffAt(), TIME_1700 );
	QCOMPARE( iSettings_t_845_1710->turnOffAt(), TIME_1710 );
}
