#include <QtTest/QtTest>
#include <QDateTime>
#include "DisplaySettings.h"
#include "TestDisplaySettings.h"

const QTime TIME_0800 = QTime( 8, 00 );
const QTime TIME_0845 = QTime( 8, 45 );
const QTime TIME_1700 = QTime( 17, 00 );
const QTime TIME_1710 = QTime( 17, 10 );

const QString DF_LONG = "dddd d MMMM yyyy";
const QString DF_SHORT = "ddd d MMM";

const QString TF_12 = "hh:mm ap";
const QString TF_24 = "hh:mm";

void TestDisplaySettings::initTestCase()
{
	iSettings_Long_12_7_800_1700 = new DisplaySettings( DisplaySettings::LongDateFormat, DisplaySettings::TwelveHoursTimeFormat, DisplaySettings::WholeWeekInSchedule, TIME_0800, TIME_1700 );
	iSettings_Short_24_5_845_1710 = new DisplaySettings( DisplaySettings::ShortDateFormat, DisplaySettings::TwentyFourHoursTimeFormat, DisplaySettings::WeekdaysInSchedule, TIME_0845, TIME_1710 );
	QVERIFY( iSettings_Long_12_7_800_1700 != 0 );
	QVERIFY( iSettings_Short_24_5_845_1710 != 0 );
}

void TestDisplaySettings::cleanupTestCase()
{
	delete iSettings_Long_12_7_800_1700;
	iSettings_Long_12_7_800_1700 = 0;

	delete iSettings_Short_24_5_845_1710;
	iSettings_Short_24_5_845_1710 = 0;
}

void TestDisplaySettings::init()
{
	//qDebug("Debug line");
}

void TestDisplaySettings::cleanup()
{
	//nothing to do
}

void TestDisplaySettings::testDateFormat()
{
	QCOMPARE( iSettings_Long_12_7_800_1700->dateFormat(), DF_LONG );
	QCOMPARE( iSettings_Short_24_5_845_1710->dateFormat(), DF_SHORT );
}

void TestDisplaySettings::testTimeFormat()
{
	QCOMPARE( iSettings_Long_12_7_800_1700->timeFormat(), TF_12 );
	QCOMPARE( iSettings_Short_24_5_845_1710->timeFormat(), TF_24 );
}

void TestDisplaySettings::testDaysInSchedule()
{
	QCOMPARE( iSettings_Long_12_7_800_1700->daysInSchedule(), DisplaySettings::WholeWeekInSchedule );
	QCOMPARE( iSettings_Short_24_5_845_1710->daysInSchedule(), DisplaySettings::WeekdaysInSchedule );
}

void TestDisplaySettings::testDayStartsAt()
{
	QCOMPARE( iSettings_Long_12_7_800_1700->dayStartsAt(), TIME_0800 );
	QCOMPARE( iSettings_Short_24_5_845_1710->dayStartsAt(), TIME_0845 );
}

void TestDisplaySettings::tetsDayEndsAt()
{
	QCOMPARE( iSettings_Long_12_7_800_1700->dayEndsAt(), TIME_1700 );
	QCOMPARE( iSettings_Short_24_5_845_1710->dayEndsAt(), TIME_1710 );
}
