#include <QtTest/QtTest>
#include "ConnectionSettings.h"
#include "TestConnectionSettings.h"

static const QString URL = "http://this.is.just/a_test_url/for unit test";
static const QString USERNAME = "Username";
static const QString PASSWORD = "Password";
static const unsigned int INTERVAL = 60;

void TestConnectionSettings::initTestCase()
{
	iConnection = new ConnectionSettings( QUrl( URL ), USERNAME, PASSWORD, INTERVAL );
	QVERIFY( iConnection != 0 );
}

void TestConnectionSettings::cleanupTestCase()
{
	delete iConnection;
	iConnection = NULL;
}

void TestConnectionSettings::init()
{
	//qDebug("Debug line");
}

void TestConnectionSettings::cleanup()
{
	//nothing to do
}

void TestConnectionSettings::testServerUrl()
{
	QCOMPARE( iConnection->serverUrl().toString(), URL );
}

void TestConnectionSettings::testUsername()
{
	QCOMPARE( iConnection->username(), USERNAME );
}

void TestConnectionSettings::testPassword()
{
	QCOMPARE( iConnection->password(), PASSWORD );
}

void TestConnectionSettings::testInterval()
{
	QCOMPARE( iConnection->refreshInterval(), INTERVAL );
}
