#include <QtTest/QtTest>
#include "Configuration.h"
#include "ConnectionSettings.h"
#include "DisplaySettings.h"
#include "StartupSettings.h"
#include "Room.h"
#include "TestConfiguration.h"

void TestConfiguration::initTestCase()
{
	iConf = Configuration::instance();
	QVERIFY( iConf != 0 );
}

void TestConfiguration::cleanupTestCase()
{
	delete iConf;
	iConf = NULL;
}

void TestConfiguration::init()
{
}

void TestConfiguration::cleanup()
{
}

void TestConfiguration::testInstance()
{
	QCOMPARE( iConf, Configuration::instance() );
}

void TestConfiguration::testDefaultRoom()
{
	Room* room = iConf->defaultRoom();
	QVERIFY( room != 0 );
	QCOMPARE( room->name(), QString( "Taurus" ) );
	QCOMPARE( room->address(), QString( "meetingroom.taurus_jyv@ixonos.com" ) );
}

void TestConfiguration::testConnectionSettings()
{
	ConnectionSettings* conn = iConf->connectionSettings();
	QVERIFY( conn != 0 );
	QCOMPARE( conn->serverUrl().toString(), QString( "jklexch01.ixonos.com" ) );
	QCOMPARE( conn->username(), QString( "username" ) );
	QCOMPARE( conn->password(), QString( "password" ) );
	QCOMPARE( conn->refreshInterval(), ( unsigned int ) 65 );
}

void TestConfiguration::testLanguageCode()
{
	QCOMPARE( iConf->languageCode(), QString( "EN" ) );
}

void TestConfiguration::testRooms()
{
	QList<Room*> testrooms;
	testrooms.append( new Room( "Taurus", "meetingroom.taurus_jyv@ixonos.com" ) );
	testrooms.append( new Room( "Pegasus", "meetingroom.pegasus_jyv@ixonos.com" ) );
	testrooms.append( new Room( "Hercules", "meetingroom.hercules@ixonos.com" ) );

	QList<Room*> rooms = iConf->rooms();
	QVERIFY( rooms.count() == 3 );
	QCOMPARE( rooms[0], iConf->defaultRoom() );
	for ( int i = 0; i < rooms.count(); i++ )
	{
		Room* room = rooms[i];
		Room* testroom = testrooms[i];
		QCOMPARE( room->name(), testroom->name() );
		QCOMPARE( room->address(), testroom->address() );
	}
}

void TestConfiguration::testStartupSettings()
{
	StartupSettings *settings = iConf->startupSettings();

	QVERIFY( settings->isPowersavingEnabled() == false );
	QCOMPARE( settings->turnOnAt(), QTime( 8, 00 ) );
	QCOMPARE( settings->turnOffAt(), QTime( 17, 00 ) );
}

void TestConfiguration::testDisplaySettings()
{
	DisplaySettings *settings = iConf->displaySettings();

	QVERIFY( settings->daysInSchedule() == DisplaySettings::WeekdaysInSchedule );
	QCOMPARE( settings->dayStartsAt(), QTime( 8, 00 ) );
	QCOMPARE( settings->dayEndsAt(), QTime( 17, 00 ) );
	QCOMPARE( settings->dateFormat(), QString( "ddd d MMM" ) );
	QCOMPARE( settings->timeFormat(), QString( "hh:mm" ) );
}

void TestConfiguration::testAdminPassword()
{
	QCOMPARE( iConf->adminPassword(), QString( "admin" ) );
}
