#include <QtTest/QtTest>
#include "Clock.h"
#include <QSignalSpy>
#include "TestClock.h"

void TestClock::initTestCase()
{
	iClock = new Clock();
	QVERIFY( iClock != 0 );
	QSignalSpy spy( iClock, SIGNAL( tick( QDateTime ) ) );
	QVERIFY( spy.isValid() );
	QTest::qWait( 5000 );
	QVERIFY( spy.count() > 0 );
	QList<QVariant> args = spy.takeFirst();
	QVERIFY( args.at( 0 ).type() == QVariant::DateTime );
}

void TestClock::cleanupTestCase()
{
	delete iClock;
	iClock = 0;
}

void TestClock::testDatetime()
{
	QCOMPARE( iClock->datetime(), QDateTime::currentDateTime() );
}

void TestClock::testDate()
{
	QCOMPARE( iClock->today(), QDateTime::currentDateTime().date() );
}

void TestClock::testTime()
{
	QCOMPARE( iClock->time(), QDateTime::currentDateTime().time() );
}

void TestClock::testSynchronizeDatetime()
{
	iClock->syncronizeDateTime();
}
