#include <QtTest/QtTest>
#include <QSignalSpy>

#include "Engine.h"
#include "Clock.h"
#include "Configuration.h"
#include "Room.h"
#include "Meeting.h"
#include "TestEngine.h"


void TestEngine::initTestCase()
{
	iEngine = new Engine;
	QVERIFY( iEngine != 0 );
}

void TestEngine::cleanupTestCase()
{
	delete iEngine;
	iEngine = 0;
}

void TestEngine::testClock()
{
	( void )iEngine->clock();
}

void TestEngine::testConfiguration()
{
	QCOMPARE( iEngine->configuration(), Configuration::instance() );
}

void TestEngine::testDefaultRoom()
{
	QCOMPARE( iEngine->defaultRoom()->equals( Configuration::instance()->defaultRoom() ), true );
}

void TestEngine::testRoomStatusInfoNeeded()
{
	QSignalSpy spy( iEngine, SIGNAL( roomStatusChanged( Room*, Room::Status, QTime ) ) );
	Room* room = new Room( "foo", "bar" );
	iEngine->roomStatusInfoNeeded( room );
	QVERIFY( spy.count() );
	delete room;
}

void TestEngine::testFetchMeetings()
{
	Room* room = new Room( "foo", "bar" );
	iEngine->fetchMeetings( QDateTime( QDate( 2009, 4, 1 ), QTime( 0, 0, 0 ) ),
					QDateTime( QDate( 2009, 4, 25 ), QTime( 0, 0, 0 ) ), room );
	delete room;
}

void TestEngine::testCreateMeeting()
{
	Room* room = new Room( "foo", "bar" );
	Meeting* meeting = new Meeting( 1234, room, QDateTime( QDate( 2009, 4, 1 ), QTime( 12, 0, 0 ) ),
						  QDateTime( QDate( 2009, 4, 1 ), QTime( 12, 30, 0 ) ) );
	iEngine->createMeeting( meeting, "foo", "bar" );
	delete meeting;
	delete room;
}

void TestEngine::testUpdateMeeting()
{
	Room* room = new Room( "foo", "bar" );
	Meeting* meeting = new Meeting( 1234, room, QDateTime( QDate( 2009, 4, 1 ), QTime( 12, 0, 0 ) ),
						  QDateTime( QDate( 2009, 4, 1 ), QTime( 12, 30, 0 ) ) );
	iEngine->updateMeeting( meeting, "foo", "bar" );
	delete meeting;
	delete room;
}

void TestEngine::testDeleteMeeting()
{
	Room* room = new Room( "foo", "bar" );
	Meeting* meeting = new Meeting( 1234, room, QDateTime( QDate( 2009, 4, 1 ), QTime( 12, 0, 0 ) ),
						  QDateTime( QDate( 2009, 4, 1 ), QTime( 12, 30, 0 ) ) );
	iEngine->deleteMeeting( meeting, "foo", "bar" );
	delete meeting;
	delete room;
}

void TestEngine::testCurrentRoomChanged()
{
	Room* room = new Room( "foo", "bar" );
	iEngine->currentRoomChanged( room );
	delete room;
}
