#ifndef SETTINGSVIEW_H_
#define SETTINGSVIEW_H_

#include "ObservedWidget.h"

class QTabWidget;
class QPushButton;
class QLineEdit;
class QTimeEdit;
class QRadioButton;
class QCheckBox;

//! User interface class. Shows the settings view and handles configuration changes.
class SettingsView : public ObservedWidget
{
	Q_OBJECT

public:
	//! Constructor.
	/*!
	 * Constructor to initialize and prepare the settings view. This calls internally
	 * the helper methods to initialize individual setting tabs.
	 * \param Parent component.
	 */
	SettingsView( QWidget *aParent = 0 );
	//! Destructor.
	virtual ~SettingsView();

private slots:
	//! Slot to handle the Ok button pressing.
	void okClicked();
	//! Slot to handle the cancel button pressing.
	void cancelClicked();

private:
	//! Initialize "Settings" tab.
	QWidget *initSettingsTab();
	//! Initialize "Week View" tab.
	QWidget *initWeekViewTab();
	//! Intialize "Resources" tab.
	QWidget *initResourcesTab();
	//! Initialize "KIOSK Mode" tab.
	QWidget *initKioskModeTab();

	//! The tabbed settings view component.
	QTabWidget *iTabWidget;
	//! OK button to dismiss the settings view with saving the settings.
	QPushButton *iOkButton;
	//! Cancel button to dismiss the settings view without saving settings.
	QPushButton *iCancelButton;
	//! Settings tab.
	QWidget *iSettingsTab;
	//! Week View tab.
	QWidget *iWeekViewTab;
	//! Resources tab.
	QWidget *iResourcesTab;
	//! KIOSK Mode tab.
	QWidget *iKioskModeTab;

	//! User name to the remote server.
	QLineEdit *iUserName;
	//! Password to the remote server.
	QLineEdit *iPassword;
	//! Remote server address.
	QLineEdit *iServerAddress;
	//! Refresh interval in seconds.
	QLineEdit *iRefreshInterval;
	//! When the day starts in the calendar view.
	QTimeEdit *iDayStartTime;
	//! When the day ends in the calendar view.
	QTimeEdit *iDayEndTime;
	//! Selection for showing five days in the calendar.
	QRadioButton *iFiveDays;
	//! Selection for showing seven days in the calendar.
	QRadioButton *iSevenDays;
	//! Power saving enabling.
	QCheckBox *iPowerSaveEnabled;
	//! Start time for activating power save.
	QTimeEdit *iPowerSaveStartTime;
	//! End time for deactivating power save.
	QTimeEdit *iPowerSaveEndTime;
};

#endif /*SETTINGSVIEW_H_*/
