#ifndef MEETINGINFODIALOG_H_
#define MEETINGINFODIALOG_H_

#include <QDialog>

class Meeting;
class QLabel;

//! UserInterface class. Provides detailed information about meetings in a dialog box.
/*!
 * UserInterface class. Provides detailed information about meetings in a dialog box.
 */
class MeetingInfoDialog : public QDialog
{
public:
	//! Constructor.
	/*!
	 * Constructor to initialize MeetingInfoDialog instances.
	 * \param aMeeting The Meeting instance which is needed to be presented in detail.
	 * \param aParent Pointer to the parent widget. Optional.
	 */
	MeetingInfoDialog( Meeting *aMeeting, QWidget *aParent = 0 );
	//! Destructor.
	virtual ~MeetingInfoDialog();

private:

	static const int width = 200;
	static const int height = 400;

};

#endif /*MEETINGINFODIALOG_H_*/
