#include "MeetingInfoDialog.h"
#include "ToolBox.h"
#include "Meeting.h"
#include "Room.h"
#include <QLabel>
#include <QVBoxLayout>
#include <QPushButton>
#include <QTextEdit>
#include <QDebug>

MeetingInfoDialog::MeetingInfoDialog( Meeting *aMeeting, QWidget *aParent ) :
		QDialog( aParent )
{
	setWindowTitle( tr( "Details" ) );

	QFont normalFont;
	normalFont.setPointSize( 11 );

	QFont boldFont;
	boldFont.setPointSize( 11 );
	boldFont.setBold( true );

	QLabel *subjectLabel = ToolBox::createLabel( tr( "Subject:" ), boldFont );
	QLabel *subjectContent = ToolBox::createLabel( aMeeting->subject(), normalFont );

	QLabel *descriptionLabel = ToolBox::createLabel( tr( "Description:" ), boldFont );
	QTextEdit *descriptionContent = new QTextEdit( "" ); // FIXME get description from Meeting class
	descriptionContent->setReadOnly( true );
	descriptionContent->setFont( normalFont );

	QLabel *organizerLabel = ToolBox::createLabel( tr( "Organizer:" ), boldFont );
	QLabel *organizerContent = ToolBox::createLabel( aMeeting->organizer(), normalFont );

	QLabel *startsAtLabel = ToolBox::createLabel( tr( "Starts at:" ), boldFont );
	QLabel *startsAtContent = ToolBox::createLabel( aMeeting->startsAt().toString( tr( "d MMMM yyyy hh:mm" ) ), normalFont );

	QLabel *endsAtLabel = ToolBox::createLabel( tr( "Ends at:" ), boldFont );
	QLabel *endsAtContent = ToolBox::createLabel( aMeeting->endsAt().toString( tr( "d MMMM yyyy hh:mm" ) ), normalFont );

	QPushButton *button = new QPushButton;
	button->setText( tr( "OK" ) );
	connect( button, SIGNAL( clicked() ), this, SLOT( close() ) );

	QHBoxLayout *buttonLayout = new QHBoxLayout;
	buttonLayout->addStretch();
	buttonLayout->addWidget( button );
	buttonLayout->addStretch();

	QVBoxLayout *layout = new QVBoxLayout;
	layout->addWidget( subjectLabel );
	layout->addWidget( subjectContent );
	layout->addSpacing( 5 );
	layout->addWidget( descriptionLabel );
	layout->addWidget( descriptionContent );
	layout->addSpacing( 5 );
	layout->addWidget( organizerLabel );
	layout->addWidget( organizerContent );
	layout->addSpacing( 5 );
	layout->addWidget( startsAtLabel );
	layout->addWidget( startsAtContent );
	layout->addSpacing( 5 );
	layout->addWidget( endsAtLabel );
	layout->addWidget( endsAtContent );
	layout->addSpacing( 5 );
	layout->addStretch();
	layout->addLayout( buttonLayout );
	setLayout( layout );

	setMinimumWidth( MeetingInfoDialog::width );
	setMinimumHeight( MeetingInfoDialog::height );
}

MeetingInfoDialog::~MeetingInfoDialog()
{
}
