#ifndef PASSWORDDIALOG_H_
#define PASSWORDDIALOG_H_

#include <QDialog>

class QLineEdit;
class QByteArray;

//! UserInterface class. Responsible for poping-up password query on the screen.
/*!
 * UserInterface class. Responsible for poping-up password query on the screen. The class is used
 * through static method, just like the QMessageBox in the standard Qt library.
 */
class PasswordDialog : public QDialog
{
	Q_OBJECT

public:
	//! Enumeration of password authenticity.
	/*!
	 * Password authenticity.
	 */
	enum PasswordStatus
	{
		Correct, /*!< Correct password. */
		Incorrect, /*!< Incorrect password. */
		Canceled
	};

	//! Creates a new PasswordDialog instance and shows the dialog on the screen.
	/*!
	 * Creates a new Password query dialog.
	 * \param aParent The parent object.
	 * \param aPassword The password.
	 * \param aText Optional. Text displayed in the dialog.
	 * \param aTitle Optional. Dialog title, defaults to "Enter password".
	 * \return The instance which was created.
	 */
	static PasswordDialog * query( QWidget *aParent, const QString &aPassword,
						 const QString &aText = 0, const QString &aTitle = 0 );

signals:
	//! Signals the authenticity of the password when the uuser dismisses the dialog.
	/*!
	 * The signal is emitted if user presses a key available for the dialog.
	 * \param aStatus Password authenticity.
	 */
	void passwordEntered( PasswordDialog::PasswordStatus aStatus );

private slots:
	void okButtonPressed();
	void cancelButtonPressed();

private:
	//! Constructor.
	/*!
	 * Constructor to initialize a PasswordDialog instance.
	 * \param aParent The parent object.
	 * \param aPassword The password.
	 */
	PasswordDialog( QWidget *aParent, const QString &aPassword, const QString &aText, const QString &aTitle );
	//! Destructor.
	virtual ~PasswordDialog();

	QLineEdit *iPasswordEdit;
	QString iPasswordHash;
};

#endif /*PASSWORDDIALOG_H_*/
