#ifndef TIMEDISPLAYWIDGET_H_
#define TIMEDISPLAYWIDGET_H_

#include "ObservedWidget.h"
#include <QWidget>
#include <QColor>
#include <QTime>

//! Abstact. UserInterface class. Displays time.
/*!
 * Abstact. UserInterface class. Offers  basic functionality to display time. Inherited by
 * DigitalTimeDisplayWidget.
 */
class TimeDisplayWidget : public ObservedWidget
{
	Q_OBJECT

public:
	//! Constructor.
	/*!
	 * Basic constructor of TimeDisplayWidget.
	 * \param aNow Current time
	 * \param aParent Parent widget
	 */
	TimeDisplayWidget( QTime aNow, QWidget *aParent = 0 );
	//! Destructor
	virtual ~TimeDisplayWidget();

	//! Returns the current time
	/*!
	 * \return Current time stored be the widget
	 */
	QTime time();

	//! Set background color
	/*!
	 * \param aColor Color of widget backgroud
	 */
	void setBackgroundColor( QColor aColor );
	//! Set foreground color
	/*!
	 * \param aColor Color of widget foregroud (text)
	 */
	void setForegroundColor( QColor aColor );
	//! Set frame visibility
	/*!
	 * Pure virtual function to set the visibility of the frame
	 * \param aVisible True, if frame is drawn, otherwise false.
	 */
	virtual void setFrameVisible( bool aVisible ) = 0;
	//! Set size
	/*!
	 * Pure virtual function to set the size of widget.
	 * \param aWidth
	 * \param aHeight
	 */
	virtual void setSize( int aWidth, int aHeight ) = 0;
	//! Set Font
	/*!
	 * Pure virtual function to set the font.
	 * \param aFont
	 */
	virtual void setFont( const QFont &aFont ) = 0;

public slots:
	//! Set time.
	/*!
	 * Updates the time displayd.
	 * \param aNow Current time.
	 */
	void setTime( QTime aNow );

protected:
	//! Displays the time.
	/*!
	 * Pure virtual function to display time.
	 */
	virtual void showTime() = 0;

private:
	//! Stores the time.
	QTime iCurrentTime;

};

#endif /*TIMEDISPLAYWIDGET_H_*/
