#ifndef OBSERVEDWIDGET_H_
#define OBSERVEDWIDGET_H_

#include <QWidget>

class QKeyEvent;
class QTabletEvent;
class QMouseEvent;
class QMouseEvent;
class QMouseEvent;

//! Userinterface class. Provides event monitoring.
/*!
 * UserInterface class. Provides event monitoring. The observed events are mouse, key and
 * tablet events. They are used to detect user interadtion with the specified UI element.
 */
class ObservedWidget : public QWidget
{
	Q_OBJECT

public:
	//! Constructor.
	/*!
	 * Constructor to initialize ObserverWidget instance.
	 * \param aParent The pointer to the parent widget. Optional.
	 */
	ObservedWidget( QWidget *aParent = 0 );
	//! Destructor.
	virtual ~ObservedWidget();

	//! Enables/disables monitoring of the key events.
	/*!
	 * Enables/disables monitoring of the key events. Enables if the flag is true; otherwise, disables.
	 * \param aIsMonitored The flag.
	 */
	void setKeyEventsMonitored( bool aIsMonitored );
	//! Enables/disables monitoring of the mouse events.
	/*!
	 * Enables/disables monitoring of the mouse events. Enables if the flag is true; otherwise, disables.
	 * \param aIsMonitored The flag.
	 */
	void setMouseEventsMonitored( bool aIsMonitored );
	//! Enables/disables monitoring of the tablet events.
	/*!
	 * Enables/disables monitoring of the tablet events. Enables if the flag is true; otherwise, disables.
	 * \param aIsMonitored The flag.
	 */
	void setTabletEventsMonitored( bool aIsMonitored );

signals:
	//! Signals if any of the monitored events is detected..
	/*!
	 * Signal. Emitted if any of the monitored events is detected.
	 */
	void observedEventDetected();

protected:
	//! Filters the detected events. ( TODO: improve event filtering!!! )
	/*!
	 * Filters the detected events. If an event is being filtered, nothing else can see/detect it anymore,
	 * it is like if it did not even exist.
	 * \param aWatched_object The watched object.
	 * \param aEvent The event which is being filtered.
	 * \return True if the event was filtered; otherwise, false.
	 */
	virtual bool eventFilter( QObject* aWatched_object, QEvent* aEvent );

private:
	bool iKeyEventsMonitored;
	bool iMouseEventsMonitored;
	bool iTabletEventsMonitored;

};

#endif /*OBSERVEDWIDGET_H_*/
