#include "ObservedWidget.h"

#include <QKeyEvent>
#include <QTabletEvent>
#include <QMouseEvent>
#include <QMouseEvent>
#include <QMouseEvent>

#include <QtDebug>

ObservedWidget::ObservedWidget( QWidget *aParent ) :
		QWidget( aParent ),
		iKeyEventsMonitored( true ),
		iMouseEventsMonitored( true ),
		iTabletEventsMonitored( true )
{
	setMouseTracking( true );

	installEventFilter( this );
}

ObservedWidget::~ObservedWidget()
{
}

void ObservedWidget::setKeyEventsMonitored( bool aIsMonitored )
{
	iKeyEventsMonitored = aIsMonitored;
}

void ObservedWidget::setMouseEventsMonitored( bool aIsMonitored )
{
	iMouseEventsMonitored = aIsMonitored;
}

void ObservedWidget::setTabletEventsMonitored( bool aIsMonitored )
{
	iTabletEventsMonitored = aIsMonitored;
}

bool ObservedWidget::eventFilter( QObject */*aWatched_object*/, QEvent *aEvent )
{
	switch ( aEvent->type() )
	{
		case( QEvent::KeyPress ) :
		case( QEvent::TabletMove ) :
		case( QEvent::TabletPress ) :
//		case( QEvent::MouseMove ) :
		case( QEvent::MouseButtonPress ) :
		case( QEvent::MouseButtonDblClick ) :
		{
			qDebug() << QString( "ObservedWidget::eventFilter/t%1" ).arg( aEvent->type() );
			emit observedEventDetected();
		}
		default :
		{
			break;
		}
	}
	return false;
}
