#include "MeetingRoomCombo.h"

#include <QComboBox>
#include <QVBoxLayout>
#include "Room.h"

#include <QtDebug>

MeetingRoomCombo::MeetingRoomCombo( QList<Room*> aRooms, QWidget *aParent ) :
		ObservedWidget( aParent )
{
	iRooms = aRooms;
	qSort( iRooms.begin(), iRooms.end(), Room::caseInsensitiveLessThan );

	QFont regularTextFont;
	regularTextFont.setBold( false );
	regularTextFont.setPointSize( 12 );

	iRoomCombo = new QComboBox( this );
	for ( int i = 0; i < iRooms.count(); i++ )
	{
		iRoomCombo->addItem( iRooms.at( i )->name() );
	}
	iRoomCombo->setFont( regularTextFont );
	connect( iRoomCombo, SIGNAL( currentIndexChanged( int ) ), this, SLOT( setCurrentIndex( int ) ) );
	connect( iRoomCombo, SIGNAL( currentIndexChanged( const QString & ) ), this, SLOT( setCurrentRoomBy( const QString & ) ) );

	QHBoxLayout *layout = new QHBoxLayout;
	layout->addWidget( iRoomCombo );
	layout->setMargin( 0 );
	setLayout( layout );
}

MeetingRoomCombo::~MeetingRoomCombo()
{
	delete iRoomCombo;
	iRooms.clear();
}

int MeetingRoomCombo::count()
{
	return iRoomCombo->count();
}

int MeetingRoomCombo::currentIndex()
{
	return iRoomCombo->currentIndex();
}

Room* MeetingRoomCombo::currentRoom()
{
	return currentIndex() >= 0 ? iRooms.at( currentIndex() ) : 0;
}

void MeetingRoomCombo::setCurrentIndex( int aIndex )
{
	if ( 0 <= aIndex && aIndex < count() )
	{
		iRoomCombo->setCurrentIndex( aIndex );
	}
	else
	{
		iRoomCombo->setCurrentIndex( -1 );
	}

	emit currentRoomChanged( currentRoom() );
	emit currentIndexChanged( currentIndex() );
}

void MeetingRoomCombo::setCurrentRoom( Room *aRoom )
{
	setCurrentIndex( findRoom( aRoom ) );
}

void MeetingRoomCombo::setCurrentRoomBy( const QString &aName )
{
	setCurrentIndex( findRoomBy( aName ) );
}

int MeetingRoomCombo::findRoom( Room *aRoom )
{
	if ( aRoom == 0 )
	{
		qDebug() << "MeetingRoomCombo::findRoom\t-1";
		return -1;
	}

	for ( int i = 0; i < iRooms.count(); i++ )
	{
		if ( aRoom->equals( iRooms.at( i ) ) )
		{
			qDebug() << "MeetingRoomCombo::findRoom\t" << i;
			return i;
		}
	}
	qDebug() << "MeetingRoomCombo::findRoom\t-1";
	return -1;
}

int MeetingRoomCombo::findRoomBy( const QString &aName )
{
	return iRoomCombo->findText( aName );
}



