#ifndef DIGITALTIMEDISPLAYWIDGET_H_
#define DIGITALTIMEDISPLAYWIDGET_H_

#include "TimeDisplayWidget.h"

class QLCDNumber;

//! Userinterface class. Displays time in a digital display.
/*!
 * Userinterface class. Displays time in a digital display. Inherits TimeDisplayWidget and diplays time in
 * QLCDNumber display.
 */
class DigitalTimeDisplayWidget : public TimeDisplayWidget
{
	Q_OBJECT

public:
	//! Constructor.
	/*!
	 * Constructor to initialize a DigitalTimeDisplayWidget instance.
	 * \param aNow Current time.
	 * \param aFormat Time display format.
	 * \param aParent Parent widget. Optional.
	 */
	DigitalTimeDisplayWidget( QTime aNow, QString aFormat, QWidget *aParent = 0 );
	//! Destructor.
	virtual ~DigitalTimeDisplayWidget();

	//! Sets frame visibility.
	/*!
	 * Setst the visibility of the frame around this widget.
	 * \param aVisible True, if frame is drawn, otherwise false.
	 */
	virtual void setFrameVisible( bool aVisible );
	//! Sets size.
	/*!
	 * Sets the size.
	 * \param aWidth Width of the widget on the screen.
	 * \param aHeight Height of the widget on the screen.
	 */
	virtual void setSize( int aWidth, int aHeight );
	//! Sets Font
	/*!
	 * Sets the font.
	 * \param aFont The new font.
	 */
	virtual void setFont( const QFont &aFont );

protected:
	//! Displays the time.
	/*!
	 * Displays the time in LCD number display.
	 */
	virtual void showTime();

private:
	//! Display to show the time.
	QLCDNumber *iDisplay;
	//! Format used to show time.
	QString iTimeFormat;

};

#endif /*DIGITALTIMEDISPLAYWIDGET_H_*/
