#include "DigitalTimeDisplayWidget.h"
#include <QLCDNumber>
#include <QVBoxLayout>

//const QString timeFormat( "hh:mm" ); //time display format

DigitalTimeDisplayWidget::DigitalTimeDisplayWidget( QTime aNow, QString aFormat, QWidget *aParent ) :
		TimeDisplayWidget( aNow, aParent ), iTimeFormat( aFormat )
{
	iDisplay = new QLCDNumber( this );
	iDisplay->setSegmentStyle( QLCDNumber::Flat );

	QVBoxLayout *layout = new QVBoxLayout;
	layout->addWidget( iDisplay );
	layout->setMargin( 0 );
	setLayout( layout );

	showTime();
}

DigitalTimeDisplayWidget::~DigitalTimeDisplayWidget()
{
	delete iDisplay;
	iDisplay = 0;
}

void DigitalTimeDisplayWidget::setFrameVisible( bool aVisible )
{
	if ( aVisible )
	{
		iDisplay->setFrameShape( QFrame::Box );
	}
	else
	{
		iDisplay->setFrameShape( QFrame::NoFrame );
	}
}

void DigitalTimeDisplayWidget::setSize( int aWidth, int aHeight )
{
	if ( aWidth > 0 && aHeight > 0 )
	{
		setFixedSize( aWidth, aHeight );
	}
}

void DigitalTimeDisplayWidget::showTime()
{
	iDisplay->display( time().toString( iTimeFormat ) );
}

void DigitalTimeDisplayWidget::setFont( const QFont &aFont )
{
	iDisplay->setFont( aFont );
}
