#ifndef HWKEYLISTENER_H_
#define HWKEYLISTENER_H_

#include <QObject>

class QCoreApplication;

//! DeviceControl class. Monitors hardware key presses.
/*!
 * DeviceControl class. Listens the hardware key presses and emits a related signal for the essential ones.
 */
class HWKeyListener : public QObject
{
	Q_OBJECT
public:
	//! Constructor.
	/*!
	 * Constructor for HWKeyListener class
	 */
	HWKeyListener();
	//! Destructor.
	virtual ~HWKeyListener();

signals:
	//! Signals if user presses F6 (Full screen) hardware key
	/*!
	 * The signal is emitted if user presses F6 (Full Screen) hardware key
	 */
	void HWKeyFullScreenPressed( );
	//! Signals if user presses F7 (Zoom out) hardware key
	/*!
	 * The signal is emitted if user presses F7 (Zoom out) hardware key
	 */
	void HWKeyZoomOutPressed( );
	//! Signals if user presses F8 (Zoom in) hardware key
	/*!
	 * The signal is emitted if user presses F8 (Zoom in) hardware key
	 */
	void HWKeyZoomInPressed( );

protected:
	//! Monitors user's interaction and controls functionality based on user's actions.
	/*!
	 * Monitors user's interaction and controls functionality based on user's actions.
	 */
	virtual bool eventFilter( QObject *aWatched_object, QEvent *e );

private:
	QCoreApplication *iApplication;

};

#endif /*HWKEYLISTENER_H_*/
