#include "HWKeyListener.h"

#include <QCoreApplication>
#include <QKeyEvent>
#include <QtDebug>

HWKeyListener::HWKeyListener() : QObject()
{
	iApplication = QCoreApplication::instance( );
	iApplication->installEventFilter( this );
}

HWKeyListener::~HWKeyListener()
{

}

bool HWKeyListener::eventFilter( QObject*, QEvent* e )
{
	if ( e->type() == QEvent::KeyPress )
	{
		QKeyEvent *keyEvent = static_cast<QKeyEvent *>( e );
		switch ( keyEvent->key() )
		{
			case Qt::Key_F6:
				qDebug() << "HW key full screen pressed";
				emit HWKeyFullScreenPressed();
				break;
			case Qt::Key_F7:
				qDebug() << "HW key zoom out pressed";
				emit HWKeyZoomOutPressed();
				break;
			case Qt::Key_F8:
				qDebug() << "HW key zoom in pressed";
				emit HWKeyZoomInPressed();
		}
	}
	return false;
}
