#ifndef COMMUNICATIONMANAGER_H_
#define COMMUNICATIONMANAGER_H_

#include <QObject>
#include <QList>
#include <QDateTime>

#include <QHttp>
#include <QAuthenticator>

class ConnectionSettings;
class ActiveSyncHttp;
class Meeting;
class Room;
class Communication;

class QHttpResponseHeader;

typedef struct QueuedActionFetchMeetings
{
	QDateTime iFrom;
	QDateTime iUntil;
	Room* iRoom;
};

enum QueuedActionModifyAction
{
	ECreateMeeting = 1,
	EUpdateMeeting,
	DeleteMeeting
};

typedef struct QueuedActionModifyMeetings
{
	QueuedActionModifyAction iType;
	QDateTime iFrom;
	QDateTime iUntil;
	Room* iRoom;
};

class CommunicationManager : public QObject
{
	Q_OBJECT

public:
	CommunicationManager( ConnectionSettings *aConnection );
	virtual ~CommunicationManager();

signals:
	void error( int aCode );
	void meetingsFetched( QList<Meeting*> aMeetings );

public slots:
	void handleFetchingError( int aCode );
	void handleModifyingError( int aCode );
	void handleMeetingsFetched( QList<Meeting*> aMeetings );

	void fetchMeetings( const QDateTime &aFrom, const QDateTime &aUntil, Room *aIn );
	void createMeeting( const Meeting *aMeeting, const QString &aUsername, const QString &aPassword ) {};
	void updateMeeting( const Meeting *aMeeting, const QString &aUsername, const QString &aPassword ) {};
	void deleteMeeting( const Meeting *aMeeting, const QString &aUsername, const QString &aPassword ) {};

private:
	ConnectionSettings *iConnectionSettings;
	Communication* iFetchingCommunication;
	Communication* iModifyingCommunication;
	QList<QueuedActionFetchMeetings*> iQueueFetchMeetings;
	QList<QueuedActionModifyMeetings*> iQueueModifyMeetings;
	//QHttp* iHttp;
	//QByteArray* iResponse;
};

#endif /*COMMUNICATIONMANAGER_H_*/
