#include "CommunicationManager.h"
#include "Communication.h"

#include <QList>
#include "ConnectionSettings.h"
#include "Meeting.h"
#include "Room.h"

// temporarly here
#include "Configuration.h"
#include <QDateTime>
#include <QDomDocument>
#include <QFile>
#include <QtDebug>

CommunicationManager::CommunicationManager( ConnectionSettings *aConnection )
{
	this->iConnectionSettings = new ConnectionSettings( *aConnection );
	iModifyingCommunication = NULL;
	iFetchingCommunication = new Communication( aConnection );

	if ( iFetchingCommunication )
	{
		connect( iFetchingCommunication, SIGNAL( error( int ) ), this, SLOT( handleFetchingError( int ) ) );
		connect( iFetchingCommunication, SIGNAL( meetingsFetched( QList<Meeting*> ) ), this, SLOT( handleMeetingsFetched( QList<Meeting*> ) ) );
	}
	//connect( iModifyingCommunication, SIGNAL( meetingsFetched( QList<Meeting*> ) ), this, SLOT( meetingsFetched( meetingsFetched( QList<Meeting*>, false ) ) );
}

CommunicationManager::~CommunicationManager()
{
	if ( iConnectionSettings != 0 )
	{
		delete iConnectionSettings;
		iConnectionSettings = 0;
	}
	if ( iModifyingCommunication )
		delete iModifyingCommunication;
	if ( iFetchingCommunication )
		delete iFetchingCommunication;
	while ( !iQueueFetchMeetings.isEmpty() )
	{
		QueuedActionFetchMeetings* item = iQueueFetchMeetings.first();
		iQueueFetchMeetings.removeFirst();
		delete item;
	}
	while ( !iQueueModifyMeetings.isEmpty() )
	{
		QueuedActionModifyMeetings* item = iQueueModifyMeetings.first();
		iQueueModifyMeetings.removeFirst();
		delete item;
	}
}

void CommunicationManager::handleFetchingError( int aCode )
{
	emit( error( aCode ) );
}

void CommunicationManager::handleModifyingError( int aCode )
{
	emit( error( aCode ) );
}

void CommunicationManager::handleMeetingsFetched( QList<Meeting*> aMeetings )
{
	QueuedActionFetchMeetings* action = iQueueFetchMeetings.first();
	iQueueFetchMeetings.removeFirst();
	delete action->iRoom;
	delete action;
	emit( meetingsFetched( aMeetings ) );

	if ( iQueueFetchMeetings.count() > NULL )
		iFetchingCommunication->fetchMeetings( iQueueFetchMeetings.first()->iFrom, iQueueFetchMeetings.first()->iUntil, iQueueFetchMeetings.first()->iRoom );
}

void CommunicationManager::fetchMeetings( const QDateTime &aFrom, const QDateTime &aUntil, Room *aIn )
{
	QueuedActionFetchMeetings* action = new QueuedActionFetchMeetings;
	action->iFrom = aFrom;
	action->iUntil = aUntil;
	action->iRoom = new Room( *aIn );

	iQueueFetchMeetings.append( action );

	if ( iQueueFetchMeetings.count() == 1 )
		iFetchingCommunication->fetchMeetings( aFrom, aUntil, aIn );
	else
		qDebug( "CommunicationManager::fetchMeetings adding action to queue" );
}
