#ifndef COMMUNICATION_H_
#define COMMUNICATION_H_

#include <QObject>
#include <QList>
#include <QDateTime>

#include <QHttp>
#include <QAuthenticator>

class ConnectionSettings;
class ActiveSyncHttp;
class Meeting;
class Room;

class QHttpResponseHeader;

class Communication : public QObject
{
	Q_OBJECT

public:
	Communication( ConnectionSettings *aConnection );
	virtual ~Communication();

signals:
	void error( int aCode );
	void meetingsFetched( QList<Meeting*> aMeetings );

public slots:
	void fetchMeetings( const QDateTime &aFrom, const QDateTime &aUntil, Room *aIn );
	void createMeeting( const Meeting *aMeeting, const QString &aUsername, const QString &aPassword ) {};
	void updateMeeting( const Meeting *aMeeting, const QString &aUsername, const QString &aPassword ) {};
	void deleteMeeting( const Meeting *aMeeting, const QString &aUsername, const QString &aPassword ) {};

	//communication-related, rearrange if needed
	void processResponse( const QHttpResponseHeader& aHeader );
	void notifyDone( bool aError );
	void handleAuthentication( const QString& aHost, quint16 aPort, QAuthenticator* aAuthenticator );
	void handleResults( int aId, bool aError );
	void notifyStateChange( int aState );

private:

	//communication-related, rearrange if needed
	bool readMeetingDataFromResponse( QList<Meeting*>& aMeetings );

private:
	ConnectionSettings *iConnectionSettings;
	QList<ActiveSyncHttp*> iActiveSyncInstances;

	//communication-related, rearrange if needed
	QHttp* iHttp;
	QByteArray* iResponse;
};

#endif /*COMMUNICATION_H_*/
