#ifndef ROOM_H_
#define ROOM_H_

#include <QString>

//! Domain class. Describe a meeting room resource on Microsoft Exchange Server 2007.
/*!
 * Domain class. Describe a meeting room resource on Microsoft Exchange Server 2007.
 */
class Room
{
public:
	//! Enumeration of the status of the room.
	/*!
	 * Enumeration of the status of the room. The room instance can have one of the two states.
	 */
	enum Status
	{
		BusyStatus, /*!< The room is reserved. */
		FreeStatus  /*!< The room is free. */
	};

public:
	//! Constructor.
	/*!
	 * Constructor to initialize a Room instance.
	 * \param aName The name of the meeting room.
	 * \param aAddress The mail address of the meeting room.
	 */
	Room( const QString &aName, const QString &aAddress );
	//! Constructor.
	/*!
	 * Copy constructor. Constructor to initialize a Room instance.
	 * \param aRoom The other Room instance which must be copied.
	 */
	Room( Room& aRoom );
	//! Destructor.
	virtual ~Room();

	//! Gets the name of the room.
	/*!
	 * Gets the name of the room.
	 * \return The string containing the name.
	 */
	QString name();
	//! Gets the address of the room.
	/*!
	 * Gets the address of the room.
	 * \return The string containing the address.
	 */
	QString address();
	//! Checks if two objects are equal.
	/*!
	 * Checks if the another same type object is equal to the current instance.
	 * \param *aOther The pointer to another Room class instance.
	 * \return TRUE if equals; otherwise, FALSE.
	 */
	bool equals( Room *aOther );
	//! Makes a string to identify a room.
	/*!
	 * Makes one string of the name and the address of the room.
	 * \return The string containing the name and address of the room.
	 */
	QString toString();
	//! Method to compare equalness of two rooms.
	/*!
	 * Compares if two rooms are equal. Is not case sensitive.
	 * \param *aRoom1 A Pointer to the first room class instance.
	 * \param *aRoom2 A Pointer to the second room class instance.
	 * \return The string containing the name and address of the room.
	 */
	static bool caseInsensitiveLessThan( Room *aRoom1, Room *aRoom2 );

private:
	//! The name for the room in this instance.
	QString	iName;
	//! The address for the room in this instance.
	QString	iAddress;

};

#endif /*ROOM_H_*/
