#include "Room.h"

Room::Room( const QString &aName, const QString &aAddress )
{
	this->iName = aName;
	this->iAddress = aAddress;
}

Room::Room( Room& aRoom )
{
	this->iName = aRoom.name();
	this->iAddress = aRoom.address();
}

Room::~Room()
{
}

QString Room::address()
{
	return iAddress;
}

QString Room::name()
{
	return iName;
}

bool Room::equals( Room *aOther )
{
	if ( iName == aOther->name()
		  && iAddress == aOther->address() )
	{
		return true;
	}
	return false;
}

QString Room::toString()
{
	QString roomToString = QString( "[Room: name:%1 address:%2 ]" )
				     .arg( iName )
				     .arg( iAddress );

	return roomToString;
}

bool Room::caseInsensitiveLessThan( Room *aRoom1, Room *aRoom2 )
{
	if ( aRoom1 == 0 || aRoom2 == 0 )
	{
		return false;
	}

	return aRoom1->name().toLower() < aRoom2->name().toLower();
}
