#include "Meeting.h"
#include "Room.h"

Meeting::Meeting( int aPrimaryId, Room *aRoom, QDateTime aStartsAt, QDateTime aEndsAt, const QString &aOrganizerName, const QString &aOrganizerEMail, const QString &aSubject, const QString &aDescription ) :
		iPrimaryId( aPrimaryId ),
		iSecondaryId( 0 ),
		iRoom( aRoom ),
		iStartsAt( aStartsAt ),
		iEndsAt( aEndsAt ),
		iOrganizerName( aOrganizerName ),
		iOrganizerEMail( aOrganizerEMail ),
		iSubject( aSubject ),
		iDescription( aDescription ),
		iDetailsAvailable( false )
{
}

Meeting::~Meeting()
{
}

Room* Meeting::room()
{
	return iRoom;
}

int Meeting::primaryId()
{
	return iPrimaryId;
}

int Meeting::secondaryId()
{
	return iSecondaryId;
}

QString Meeting::organizer()
{
	if ( iOrganizerName == "" && iOrganizerEMail != "" )
	{
		return iOrganizerEMail;
	}
	if ( iOrganizerName != "" && iOrganizerEMail == "" )
	{
		return iOrganizerName;
	}
	if ( iOrganizerEMail == "" && iOrganizerName == "" )
	{
		return "";
	}
	return QString( "%1 <%2>" ).arg( iOrganizerName ).arg( iOrganizerEMail );

}

QDateTime Meeting::startsAt()
{
	return iStartsAt;
}

QDateTime Meeting::endsAt()
{
	return iEndsAt;
}

QString Meeting::subject()
{
	return iSubject;
}

QString Meeting::description()
{
	return iDescription;
}

bool Meeting::detailsAvailable()
{
	return iDetailsAvailable;
}

void Meeting::setSecondaryId( int aSecondaryId )
{
	iSecondaryId = aSecondaryId;
	iDetailsAvailable = true;
}

void Meeting::setOrganizer( const QString &aOrganizerName, const QString &aOrganizerEMail )
{
	iOrganizerName = aOrganizerName;
	iOrganizerEMail = aOrganizerEMail;
}

void Meeting::setStartsAt( QDateTime aNewStart )
{
	iStartsAt = aNewStart;
}

void Meeting::setEndsAt( QDateTime aNewEnd )
{
	iEndsAt = aNewEnd;
}

void Meeting::setSubject( const QString &aSubject )
{
	iSubject = aSubject;
}

void Meeting::setDescription( const QString &aDescription )
{
	iDescription = aDescription;
}

bool Meeting::equals( Meeting *aOther )
{
	if ( iRoom->equals( aOther->room() )
		  && iStartsAt == aOther->startsAt()
		  && iEndsAt == aOther->endsAt()
		  && iPrimaryId == aOther->primaryId() )
	{
		return true;
	}
	return false;
}

bool Meeting::overlaps( Meeting* aOther )
{
	return (( iStartsAt >= aOther->iStartsAt && iStartsAt < aOther->iEndsAt ) ||
		  ( iStartsAt <= aOther->iStartsAt && iEndsAt > aOther->iStartsAt ) );
}

QString Meeting::toString()
{
	QString meetingToString = QString( "[MEETING: id1:%1 id2:%2 in:%3 from:%4 until:%5 by:%6 subject:%7 description:%8]" )
					  .arg( iPrimaryId )
					  .arg( iSecondaryId )
					  .arg( iRoom->toString() )
					  .arg( iStartsAt.toString() )
					  .arg( iEndsAt.toString() )
					  .arg( organizer() )
					  .arg( iSubject )
					  .arg( iDescription );

	return meetingToString;
}
