#ifndef STARTUPSETTINGS_H_
#define STARTUPSETTINGS_H_

#include <QDateTime>

//! Domain class. Stores starup settings.
/*!
 * Domain class. Stores starup settings.
 */
class StartupSettings
{
public:
	//! Constructor.
	/*!
	 * Constructor to initiazile StartupSettings instance.
	 * \param aIsPowersavingEnabled Flag which is true is powersaving enabled; otherwise, false.
	 * \param aTurnOnAt Time when the device must be turned on if flag is true.
	 * \param aTurnOffAt Time when the device must be turned off if flag is true.
	 */
	StartupSettings( bool aIsPowersavingEnabled, QTime aTurnOnAt, QTime aTurnOffAt );
	//! Destructor
	virtual ~StartupSettings();

	//! Gets powersaving flag.
	/*!
	 * Gets powersaving flag.
	 * \return True if power saving option is used, otherwise false.
	 */
	bool isPowersavingEnabled();
	//! Gets time to turn on device.
	/*!
	 * Gets time to turn on device.
	 * \return Time to automatically turn on device.
	 */
	QTime turnOnAt();
	//! Gets time to turn off device.
	/*!
	 * Gets time to turn off device.
	 * \return Time to automatically turn off device.
	 */
	QTime turnOffAt();

	//! Sets powersaving flag.
	/*!
	 * Sets powersaving flag.
	 * \param aEnabled If true, power saving option is used.
	 */
	void setPowersavingEnabled( bool aEnabled );
	//! Sets time to turn on device.
	/*!
	 * Sets time to turn on device.
	 * \param aTurnOn Time to automatically turn on device.
	 */
	void setTurnOnAt( QTime aTurnOn );
	//! Sets time to turn off device.
	/*!
	 * Sets time to turn off device.
	 * \param aTurnOff Time to automatically turn off device.
	 */
	void setTurnOffAt( QTime aTurnOff );


private:
	bool iIsPowersavingEnabled;
	QTime iTurnOnAt;
	QTime iTurnOffAt;

};

#endif /*STARTUPSETTINGS_H_*/
