#include "DisplaySettings.h"
#include <QObject>

DisplaySettings::DisplaySettings( DateFormat aDateFormat, TimeFormat aTimeFormat, DaysInSchedule aDaysInSchedule, QTime aDayStartsAt, QTime aDayEndsAt, int aScreensaver ) :
		iDateFormat( aDateFormat ),
		iTimeFormat( aTimeFormat ),
		iDaysInSchedule( aDaysInSchedule ),
		iDayStartsAt( aDayStartsAt ),
		iDayEndsAt( aDayEndsAt ),
		iScreensaver( aScreensaver )
{
}

DisplaySettings::~DisplaySettings()
{
}

QString DisplaySettings::dateFormat()
{

	QString format;
	switch ( iDateFormat )
	{
		case DisplaySettings::LongDateFormat :
		{
			format = QObject::tr( "dddd d MMMM yyyy" );
			break;
		}
		case DisplaySettings::ShortDateFormat :
		default:
		{
			format = QObject::tr( "ddd d MMM" );
			break;
		}
	}
	return format;
}

QString DisplaySettings::timeFormat()
{
	QString format;
	switch ( iTimeFormat )
	{
		case DisplaySettings::TwelveHoursTimeFormat :
		{
			format = QObject::tr( "hh:mm ap" );
			break;
		}
		case DisplaySettings::TwentyFourHoursTimeFormat :
		default:
		{
			format = QObject::tr( "hh:mm" );
			break;
		}
	}
	return format;
}

DisplaySettings::DaysInSchedule DisplaySettings::daysInSchedule()
{
	return iDaysInSchedule;
}

QTime DisplaySettings::dayStartsAt()
{
	return iDayStartsAt;
}

QTime DisplaySettings::dayEndsAt()
{
	return iDayEndsAt;
}

int DisplaySettings::screensaver()
{
	return iScreensaver;
}

void DisplaySettings::setDateFormat( DateFormat aDateFormat )
{
	iDateFormat = aDateFormat;
}

void DisplaySettings::setTimeFormat( TimeFormat aTimeFormat )
{
	iTimeFormat = aTimeFormat;
}

void DisplaySettings::setDaysInSchedule( DaysInSchedule aDaysInSchedule )
{
	iDaysInSchedule = aDaysInSchedule;
}

void DisplaySettings::setDayStartsAt( QTime aDayStartsAt )
{
	iDayStartsAt = aDayStartsAt;
}

void DisplaySettings::setDayEndsAt( QTime aDayEndsAt )
{
	iDayEndsAt = aDayEndsAt;
}

void DisplaySettings::setScreensaver( int aWaitTime )
{
	iScreensaver = aWaitTime;
}
