#include "ConnectionSettings.h"

ConnectionSettings::ConnectionSettings( const QUrl &aServerUrl, const QString &aUsername, const QString &aPassword, unsigned int aRefreshInterval )
{
	iServerUrl = aServerUrl;
	iUsername = aUsername;
	iPassword = aPassword;
	iRefreshInterval = aRefreshInterval;
}

ConnectionSettings::ConnectionSettings( const ConnectionSettings &aOther )
{
	this->iServerUrl = aOther.iServerUrl;
	this->iUsername = aOther.iUsername;
	this->iPassword = aOther.iPassword;
	this->iRefreshInterval = aOther.iRefreshInterval;
}

ConnectionSettings::~ConnectionSettings()
{
}

QUrl ConnectionSettings::serverUrl()
{
	return iServerUrl;
}

QString ConnectionSettings::username()
{
	return iUsername;
}

QString ConnectionSettings::password()
{
	return iPassword;
}

unsigned int ConnectionSettings::refreshInterval()
{
	return iRefreshInterval;
}

void ConnectionSettings::setServerUrl( const QUrl &aServerUrl )
{
	iServerUrl = aServerUrl;
}

void ConnectionSettings::setUsername( const QString &aUsername )
{
	iUsername = aUsername;
}

void ConnectionSettings::setPassword( const QString &aPassword )
{
	iPassword = aPassword;
}

void ConnectionSettings::setRefreshInterval( unsigned int aRefreshInterval )
{
	iRefreshInterval = aRefreshInterval;
}