#ifndef ERRORMAPPER_H_
#define ERRORMAPPER_H_

#include <QString>
#include <QMap>

//! BusinessLogic class. Map error codes to error strings.
/*!
 * BusinessLogic class. Map error codes to error strings. The code-string pairs are defined in XML-file
 * which is read by the mapper at initialization and stored in a QMap. The class has only one public
 * static method which provides access to the code-string table, there is a static instance used but this
 * is transparent for the caller.
 */
class ErrorMapper
{

public:
	//! Gets the error string of the specified error code.
	/*!
	 * Gets the error string of the specified error code.
	 * \param aCode The code to which the string must be got.
	 * \return The string pair of the specified code, if found; otherwise, empty string.
	 */
	static QString codeToString( int aCode );

private:
	//! Constructor.
	/*!
	 * Constructor to initialize an ErrorMapper instance.
	 */
	ErrorMapper();
	//! Destructor.
	virtual ~ErrorMapper();

	//! Loads to code-string pairs.
	/*!
	 * Loads to code-string pairs from XML-file to a QMap object.
	 * \param aXml The XML-file which contains the error table.
	 */
	void mapFromXML( const QString &aXml );

private:
	/*!
	 * The static instance which is in use to load and store the code-string pairs.
	 */
	static ErrorMapper *sInstance;
	static QString sNotValidErrorCode;

	QMap<int, QString> iErrorTable;

};

#endif /*ERRORMAPPER_H_*/
