#include "ErrorMapper.h"

#include <QDomDocument>
#include <QDomElement>
#include <QDomNode>
#include <QFile>

ErrorMapper * ErrorMapper::sInstance = 0;
QString ErrorMapper::sNotValidErrorCode = QString( "ABC" );

ErrorMapper::ErrorMapper()
{
	Q_INIT_RESOURCE( BusinessLogic );
	mapFromXML( ":/errortable" );
}

ErrorMapper::~ErrorMapper()
{
}

void ErrorMapper::mapFromXML( const QString &aXml )
{
	// create and xml reader
	QDomDocument doc;
	QFile file( aXml );

	// open the file
	if ( !file.open( QIODevice::ReadOnly ) )
	{
		return;
	}

	// associate the content to the xml reader
	if ( !doc.setContent( &file ) )
	{
		file.close();
		return;
	}
	file.close();

	// start readin the xml file
	QDomElement root = doc.documentElement();
	// check if the file is the one we need
	if ( root.tagName().toLower() != "errors" )
	{
		return;
	}

	// loop through the nodes
	for ( QDomNode node = root.firstChild(); !node.isNull(); node = node.nextSibling() )
	{
		// read an element in the xml file
		QDomElement e = node.toElement();
		if ( !e.isNull() && e.tagName().toLower() == "error" )
		{
			bool success = false;
			int code = QString( e.attribute( "code", sNotValidErrorCode ) ).toInt( &success );
			QString text = e.text();

			// if element is correct, then store it
			if ( success )
			{
				iErrorTable.insert( code, text );
			}
		}
	}
}

QString ErrorMapper::codeToString( int code )
{
	if ( sInstance == 0 )
	{
		sInstance = new ErrorMapper;
	}
	return sInstance->iErrorTable.value( code, "" );
}
