#ifndef CLOCK_H_
#define CLOCK_H_

#include <QObject>
#include <QDateTime>

class QTimer;

//! BusinessLogic class. Provide up-to-date date and time for the whole application.
/*!
 * BusinessLogic class. Provide up-to-date date and time for the whole application. The class uses
 * openNTPD to syncronize local datetime with a remote NTP server. The NTP client must be configured.
 * The class uses ticks in every minute and signals the actual datetime information.
 */
class Clock : public QObject
{
	Q_OBJECT

public:
	//! Contructor.
	/*!
	 * Contructor to initialize a new Clock instance.
	 */
	Clock();
	//! Destructor.
	virtual ~Clock();

	//! Gets the current date and time.
	/*!
	 * Gets the current date and time.
	 * \return The current date and time.
	 */
	QDateTime datetime();
	//! Gets the current day.
	/*!
	 * Gets the current day.
	 * \return The current day.
	 */
	QDate today();
	//! Gets the current time.
	/*!
	 * Gets the current time.
	 * \return The current time.
	 */
	QTime time();

signals:
	//! Signal. Emitted in every second, it signals the actual date and time info.
	/*!
	 * Signal. Emitted in every second, it signals the actual date and time info.
	 * \param aCurrentDateTime The current date and time.
	 */
	void tick( QDateTime aCurrentDateTime );

public slots:
	//! Slot. Syncronizes the devices local date and time with a remote NTP server.
	/*!
	 * Slot. Syncronizes the devices local date and time with a remote NTP server by using
	 * openNTPD client. It launches the installed and configured klient with a system command.
	 */
	void syncronizeDateTime();

private slots:
	//! Slot. Updates the date and time info stored in the current instance.
	/*!
	 * Slot. Updates the date and time info stored in the current instance by reading the device's clock.
	 */
	void update();

private:
	QDateTime iCurrentDateTime;
	QTimer* iTimer;
};

#endif /*CLOCK_H_*/
