#include "Clock.h"
#include <QProcess>
#include <QTimer>

const int TICK_TIME = 1000; // milliseconds

Clock::Clock() :
		QObject()
{
	iCurrentDateTime = QDateTime::currentDateTime();

	iTimer = new QTimer;
	iTimer->setInterval( TICK_TIME );
	connect( iTimer, SIGNAL( timeout() ), iTimer, SLOT( start() ) );
	connect( iTimer, SIGNAL( timeout() ), this, SLOT( update() ) );
	iTimer->start();
}

Clock::~Clock()
{
	if ( iTimer != 0 )
	{
		iTimer->stop();
		delete iTimer;
	}
}

QDateTime Clock::datetime()
{
	return iCurrentDateTime;
}

QDate Clock::today()
{
	return iCurrentDateTime.date();
}

QTime Clock::time()
{
	return iCurrentDateTime.time();
}

void Clock::syncronizeDateTime()
{
	const QString systemCmd = "sudo /etc/init.d/openntpd restart";

	iTimer->stop();
	QProcess::execute( systemCmd );
	iTimer->start();
}

void Clock::update()
{
	iCurrentDateTime = QDateTime::currentDateTime();

	emit tick( datetime() );
}
