TEMPLATE = app

TARGET = qtmeetings

QT += xml \
    network

INCLUDEPATH += src/Domain/ \
    src/Domain/Configuration/ \
    src/IO/ \
    src/IO/Communication/ \
    src/IO/DeviceControl/ \
    src/BusinessLogic/ \
    src/BusinessLogic/Utils/ \
    src/UserInterface/ \
    src/UserInterface/Components/ \
    src/UserInterface/Utils/ \
    src/UserInterface/Views/

HEADERS += src/Domain/Room.h \
    src/Domain/Meeting.h \
    src/Domain/Configuration/ConnectionSettings.h \
    src/Domain/Configuration/StartupSettings.h \
    src/Domain/Configuration/DisplaySettings.h \
    src/Domain/Configuration/Configuration.h \
    src/IO/Communication/Communication.h \
    src/IO/Communication/CommunicationManager.h \
    src/IO/DeviceControl/AlarmSender.h \
    src/IO/DeviceControl/HWKeyListener.h \
    src/IO/DeviceControl/DeviceDataStorage.h \
    src/IO/DeviceControl/DeviceConfigurator.h \
    src/IO/DeviceControl/DeviceManager.h \
    src/BusinessLogic/Utils/ErrorMapper.h \
    src/BusinessLogic/Utils/Clock.h \
    src/BusinessLogic/Engine.h \
    src/UserInterface/Utils/ToolBox.h \
    src/UserInterface/Utils/PopUpMessageBox.h \
    src/UserInterface/Utils/PasswordDialog.h \
    src/UserInterface/Components/ObservedWidget.h \
    src/UserInterface/Components/TimeDisplayWidget.h \
    src/UserInterface/Components/DigitalTimeDisplayWidget.h \
    src/UserInterface/Components/MeetingRoomCombo.h \
    src/UserInterface/Components/ScheduleWidget.h \
    src/UserInterface/Views/RoomStatusIndicatorWidget.h \
    src/UserInterface/Views/WeeklyViewWidget.h \
    src/UserInterface/Views/MeetingInfoDialog.h \
    src/UserInterface/Views/SettingsView.h \
    src/UserInterface/WindowManager.h

SOURCES += src/Domain/Room.cpp \
    src/Domain/Meeting.cpp \
    src/Domain/Configuration/ConnectionSettings.cpp \
    src/Domain/Configuration/StartupSettings.cpp \
    src/Domain/Configuration/DisplaySettings.cpp \
    src/Domain/Configuration/Configuration.cpp \
    src/IO/Communication/Communication.cpp \
    src/IO/Communication/CommunicationManager.cpp \
    src/IO/DeviceControl/AlarmSender.cpp \
    src/IO/DeviceControl/HWKeyListener.cpp \
    src/IO/DeviceControl/DeviceDataStorage.cpp \
    src/IO/DeviceControl/DeviceConfigurator.cpp \
    src/IO/DeviceControl/DeviceManager.cpp \
    src/BusinessLogic/Utils/ErrorMapper.cpp \
    src/BusinessLogic/Utils/Clock.cpp \
    src/BusinessLogic/Engine.cpp \
    src/UserInterface/Utils/ToolBox.cpp \
    src/UserInterface/Utils/PopUpMessageBox.cpp \
    src/UserInterface/Utils/PasswordDialog.cpp \
    src/UserInterface/Components/ObservedWidget.cpp \
    src/UserInterface/Components/TimeDisplayWidget.cpp \
    src/UserInterface/Components/DigitalTimeDisplayWidget.cpp \
    src/UserInterface/Components/MeetingRoomCombo.cpp \
    src/UserInterface/Components/ScheduleWidget.cpp \
    src/UserInterface/Views/RoomStatusIndicatorWidget.cpp \
    src/UserInterface/Views/WeeklyViewWidget.cpp \
    src/UserInterface/Views/MeetingInfoDialog.cpp \
    src/UserInterface/Views/SettingsView.cpp \
    src/UserInterface/WindowManager.cpp \
    src/main.cpp

RESOURCES += resources/BusinessLogic.qrc \
    resources/UserInterface.qrc

CONFIG += link_pkgconfig
PKGCONFIG += libalarm

executable.files = qtmeetings
executable.path = /usr/bin/
executable.hint = executable
INSTALLS += executable

appconfig.files = QtMeetings.conf
appconfig.path = /etc/
appconfig.hint = appconfig
INSTALLS += appconfig

desktop.files = QtMeetings.desktop
desktop.path = /usr/share/applications/hildon
desktop.hint = desktop
INSTALLS += desktop

devstopper_script.files = scripts/qtmeetings-devstopper
devstopper_script.path = /usr/bin
devstopper_script.hint = devstopper_script
INSTALLS += devstopper_script

rename_script.files = scripts/qtmeetings-rename
rename_script.path = /usr/bin
rename_script.hint = rename_script
INSTALLS += rename_script

launcher_script.files = scripts/qtmeetings-launcher
launcher_script.path = /etc/init.d
launcher_script.hint = launcher_script
INSTALLS += launcher_script

unix:exists( $$system(which doxygen) ) { 
    message( "Doxygen is present in your system." )
    BUILD_NOW = $$prompt( "Do you want to build Doxygen documentation now? [YES/no]" )
    contains( BUILD_NOW, "YES" ):system( "doxygen QtMeetings.doxygen" )::message( "Documentation is built successfully." )
}
else:message( "You must install Doxygen to build the project documentation." )
message( "Now run 'make' to compile the source code." )
