/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef __WAYPOINT_H__
#define __WAYPOINT_H__

#include <QString>
#include <QtGlobal>

//! Class holds information of a point along a route.
class Waypoint
{
public:
    //! Constructor.
    Waypoint();

    //! Destructor.
    ~Waypoint();

    //! Returns the name property.
    QString getName() const { return name; }

    //! Sets the name property.
    void setName(QString name) { this->name = name; }

    //! Returns the longitude property.
    qreal getLongitude() const { return longitude; }

    //! Sets the longitude property.
    void setLongitude(qreal longitude) { this->longitude = longitude; }

    //! Returns the latitude property.
    qreal getLatitude() const { return latitude; }

    //! Sets the latitude property.
    void setLatitude(qreal latitude) { this->latitude = latitude; }

    //! Returns the heading property.
    qreal getHeading() const { return heading; }

    //! Sets the heading property.
    void setHeading(qreal heading) { this->heading = heading; }

private:
    //! The name of the point.
    QString name;

    //! The longitude at the point.
    qreal longitude;

    //! The latitude at the point.
    qreal latitude;

    //! The heading at the point.
    qreal heading;
};

#endif // __WAYPOINT_H__
