/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef UNITCONVERTER_H
#define UNITCONVERTER_H

#include <QPointF>

//! Some useful methods
class UnitConverter
{
public:
    //! class constructor
    UnitConverter();

    /*!
     * Bounds a value between given limits.
     *
     * \param x The value to be bounded
     * \param a The lower limit
     * \param b The upper limit
     */
    void bound(qreal &x, qreal a, qreal b) ;

    /*!
     * Converts degrees to radians
     *
     * \param qreal The value of angle in degrees
     * \return The value of angle in radians
     */
    qreal deg2rad(qreal);

    /*!
     * Calculates the latitude and longitude of a given pixel in mapscene.
     * Returns a QPointF object, where longitude is x and latitude is y.
     *
     * \param zoom The current zoom level
     * \param upperLeftCornerMapX the x-index of the maptile
     *                            in the upper left corner of mapscene
     * \param upperLeftCornerMapY the y-index of the maptile
     *                            in the upper left corner of mapscene
     * \param xPixel The x-coordinate of the pixel
     * \param yPixel The y-coordinate of the pixel
     */
    QPointF coordinatesFromPixels(int zoom,
                                  int upperLeftCornerMapX,
                                  int upperLeftCornerMapY,
                                  int xPixel,
                                  int yPixel);
};

#endif
