/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include <math.h>
#include <QtGlobal>
#include "unitconverter.h"
#include "definitions.h"

//! Class constructor
UnitConverter::UnitConverter()
{
}

//! Bounds a value between given limits
void UnitConverter::bound(qreal &x, qreal a, qreal b)
{
    if (x < a) {
        x = a;
    }
    else if (x > b) {
        x = b;
    }
}

//! Converts degrees to radians
qreal UnitConverter::deg2rad(qreal degrees)
{
    return degrees * pi / 180 ;
}

//! Calculates the latitude and longitude of a given pixel in mapscene
QPointF UnitConverter::coordinatesFromPixels(int zoom,
                                             int upperLeftCornerMapX,
                                             int upperLeftCornerMapY,
                                             int xPixel,
                                             int yPixel)
{
    QPointF coordinates;

    qint64 numberOfMaptiles = (qint64)pow(2, zoom);
    qint64 worldSizeInPixels = numberOfMaptiles * mapTileWidth;

    qint64 worldScaleXPixel = upperLeftCornerMapX * mapTileWidth + xPixel;
    qint64 worldScaleYPixel = upperLeftCornerMapY * mapTileHeight + yPixel;

    qreal longitude = (qreal)worldScaleXPixel / (qreal)worldSizeInPixels * 360;
    longitude -= 180;

    qreal y;
    y = 2 * pi * (1 -
                  ((qreal)worldScaleYPixel / (qreal)worldSizeInPixels)) - pi;

    qreal latitude = atan(sinh(y)) * 180 / pi;

    coordinates.setX(longitude);
    coordinates.setY(latitude);

    return coordinates;
}
