/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include <QDebug>
#include <QDomDocument>
#include <QFile>
#include <QFileDialog>
#include <QIODevice>
#include <QString>
#include <QTextStream>
#include <QTime>

#include "trackingdatawriter.h"

//! Creates a (gpx) XML file
TrackingDataWriter::TrackingDataWriter(QVector<TrackPoint> trackPoints)
{
    const QString docType = "xml";
    const QString the1stTag = "gpx";
    const QString the1stAttribute = "version";
    const QString the1stAttributeValue = "1.1";
    const QString the2stAttribute = "creator";
    const QString the2stAttributeValue = "QtMapper";
    const QString the3stAttribute = "xmlns";
    const QString the3stAttributeValue = "http://www.topografix.com/GPX/1/1";
    const QString the2stTag = "trk";
    const QString the3stTag = "trkseg";
    const QString the4stTag = "trkpt";
    const QString the5stTag = "time";
    const QString the4stAttribute = "lat";
    const QString the5stAttribute = "lon";

    QDomDocument doc(docType);
    QDomElement gpx = doc.createElement(the1stTag);
    doc.appendChild(gpx);

    QDomAttr version = doc.createAttribute(the1stAttribute);
    version.setValue(QString(the1stAttributeValue));
    gpx.setAttributeNode(version);

    QDomAttr creator = doc.createAttribute(the2stAttribute);
    creator.setValue(QString(the2stAttributeValue));
    gpx.setAttributeNode(creator);

    QDomAttr xmlns = doc.createAttribute(the3stAttribute);
    xmlns.setValue(QString(the3stAttributeValue));
    gpx.setAttributeNode(xmlns);

    QDomElement trk = doc.createElement(the2stTag);
    gpx.appendChild(trk);

    QDomElement trkSeg = doc.createElement(the3stTag);
    trk.appendChild(trkSeg);

    for (qint32 i = 0; i < trackPoints.count(); i++) {
        QDomElement trkPt = doc.createElement(the4stTag);
        trkSeg.appendChild(trkPt);

        QDomElement time = doc.createElement(the5stTag);
        QDomText timetext = doc.createTextNode(
                                trackPoints[i].getTime().toString());
        time.appendChild(timetext);
        trkPt.appendChild(time);

        QDomAttr lat = doc.createAttribute(the4stAttribute);
        lat.setValue(QString("%1").arg(trackPoints[i].getLatitude(),0,'e'));
        trkPt.setAttributeNode(lat);

        QDomAttr lon = doc.createAttribute(the5stAttribute);
        lon.setValue(QString("%1").arg(trackPoints[i].getLongitude(),0,'e'));
        trkPt.setAttributeNode(lon);
    }

    xmlDocument = doc.toString();
}

//! Saves XML file.
void TrackingDataWriter::save()
{
    QFileDialog fd;
    QString fileName;
    fileName = fd.getSaveFileName();
    
    QFile file(fileName);
    if (!file.open(QIODevice::WriteOnly | QIODevice::Text)) {
        return;
    }

    out = new QTextStream(&file);
    *out << xmlDocument;
    delete out;
}

//! Destructor
TrackingDataWriter::~TrackingDataWriter()
{

}
