/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef __TRACKINGDATAREADER_H__
#define __TRACKINGDATAREADER_H__

#include "trackpoint.h"
#include <QVector>
#include <QXmlDefaultHandler>

/*!
 * Class is for handling GPX data of track points.
 */
class TrackingDataReader : public QXmlDefaultHandler
{
public:
    /*!
     * Constructor
     *
     * \param trackPoints A reference to track points vector.
     */
    TrackingDataReader(QVector<TrackPoint> &trackPoints);

    /*!
     * Method is called when parser finds start element of GPX file.
     * Method saves data of attributes to track point object.
     * \param namespaceURI The namespace uri of the parsed document.
     * \param localName The local name of the parsed document.
     * \param qName The tag name of the parsed document.
     * \param attributes The attributes of the parsed document.
     * \return boolean true if (gpx) xml document is valid otherwise false.
     */
    bool startElement(const QString &namespaceURI, const QString &localName,
                      const QString &qName, const QXmlAttributes &attributes);

    /*!
     * Method is called when parser finds end element of GPX file.
     * Method saves character data of elements to track point object and inserts
     * the track point object to vector.
     * \param namespaceURI The namespace uri of the parsed document.
     * \param localName The local name of the parsed document.
     * \param qName The tag name of the parsed document.
     * \return boolean true.
     */
    bool endElement(const QString &namespaceURI, const QString &localName,
                    const QString &qName);

    /*!
     * Method is called when parser finds character data from GPX file.
     * Method saves character data temporarily.
     *
     * \param str the string of a characrer data.
     * \return boolean true.
     */
    bool characters(const QString &str);

private:
    //! Track point
    TrackPoint point;

    //! Track point data container
    QVector<TrackPoint> & trackPoints;

    //! current character data
    QString currentText;

    //! for checking validity of GPX file
    bool metGpxTag;
};
#endif
