/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include <QTime>
#include <QDebug>
#include "gpxhandler.h"
#include "poi.h"
#include "trackingdatareader.h"

//! Constructor
TrackingDataReader::TrackingDataReader(QVector<TrackPoint> & trackPoints)
        : trackPoints(trackPoints)
{
    metGpxTag = false;
}

//! Saves data of attributes to track point object
bool TrackingDataReader::startElement(const QString &,
                                      const QString &,
                                      const QString &qName,
                                      const QXmlAttributes &attributes)
{
    const QString gpxTag = "gpx";
    const QString trkptTag = "trkpt";
    const QString latAttribute = "lat";
    const QString lonAttribute = "lon";

    if (!metGpxTag && qName != gpxTag) {
        return false;
    }

    if (qName == gpxTag) {
        metGpxTag = true;
    }
    else if (qName == trkptTag) {
        point.setLongitude(attributes.value(lonAttribute).toDouble());
        point.setLatitude(attributes.value(latAttribute).toDouble());
       
    }

    currentText.clear();
    return true;
}

//! Saves character data of elements to track point object and inserts
bool TrackingDataReader::endElement(const QString &,
                                    const QString &,
                                    const QString &qName)
{
    const QString timeTag = "time";

    if (qName == timeTag) {
        QTime time(QTime::fromString(currentText));
        point.setTime(time);
        trackPoints.append(point);
    }

    currentText.clear();
    return true;
}

//! Saves character data temporarily
bool TrackingDataReader::characters(const QString &str)
{
    currentText += str;
    return true;
}
