/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef SPEEDDISPLAY_H
#define SPEEDDISPLAY_H

#include "displaybox.h"

#include <QFont>

class QGraphicsItem;
class QPainter;
class QStyleOptionGraphicsItem;
class QWidget;

class QPainter;

//! This is class for displaying speed value.
class SpeedDisplay : public DisplayBox
{
public:
    /*!
     * Constructor. Make sure that width is always bigger than height. Constructor
     * also checks it and use bigger value for the width and smaller for the height.
     * In constructor is locale detection which detects metrics what system uses.
     */
    SpeedDisplay(int width = 100, int height = 30, QGraphicsItem * parent = 0) ;

    /*!
     * Destructor
     */
    ~SpeedDisplay() ;

    /*!
     * inherited from upper class.
     */
    QRectF boundingRect() const ;

    /*!
     * Inherit needs this for the custom painting.
     */
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget = 0);

    /*!
     * Update speed.
     */
    void updateSpeed(qreal speed) ;


private:
    /*!
     * Measures text to fit in box.
     */
    void measure() ;

    //! width for the speed display box.
    qreal width ;

    //! height for the speed display box.
    qreal height ;

    //! variable where speed value is stored.
    QString speed ;

    //! indicates whether mile display or kilometer display.
    int speedType ;

    //! Stored suffixes for the wanted speed displaying type.
    QString speedTypeText[2] ;

    //! font for the speed.
    QFont speedFont ;

    //! enumeration indicates types of speed.
    enum {KMTYPE, MILETYPE} ;

    //! backgroundcolor for the box.
    const QColor defaultBackgroundColor ;

    //! Area where speed text is drawn. Makes sure that there is 2px frame for the text area.
    QRectF speedTextArea ;

    //! Combined speed and suffix texts. This is used for the screen.
    QString displayText ;

    //! Value for speed in kilometers.
    int speedKilometers ;

    //! converts km to mile
    int calculateMileValue() ;

    //! Convertion multiplier.
    const qreal mileConvertValue ;

    //! Generates QString value for the display.
    void createDisplayValue() ;

} ;

#endif // SPEEDDISPLAY_H
