/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef SEARCHVIEW_H
#define SEARCHVIEW_H

#include <QWebView>

class PoiDownloader;
class RouteDownloader;
class SearchLocationDownloader;

//! Used for searching data from Google Maps.
class SearchView : public QWebView
{
    Q_OBJECT

public:
    SearchView(QWidget *parent = 0);

public slots:
    //! Initialize route download.
    void initializeRouteDownload(RouteDownloader *downloader);

    //! Initialize location search.
    void initializeLocationSearch(SearchLocationDownloader *downloader);

    //! Initialize POI download.
    void initializePoiDownload(PoiDownloader *downloader);

private:
    /*!
     * Resets the QWebPage associated to this object.
     *
     * \param downloader The page to set.
     * \param data The data object of the page.
     */
    void resetPage(QWebPage *downloader, QObject *data);

private slots:
    //! Starts the download.
    void startDownload(QString &url);
};

#endif // SEARCHVIEW_H
