/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef __SEARCHLOCATIONDOWNLOADER_H__
#define __SEARCHLOCATIONDOWNLOADER_H__

#include "googlemapsdownloader.h"
#include "searchlocationdata.h"

/*!
 * Class is for downloading XML file from internet.
 */
class SearchLocationDownloader : public GoogleMapsDownloader
{
public:
    //! Constructor
    SearchLocationDownloader(QObject *data, QObject *parent = 0);

    /*!
     * Download data from Google Maps.
     *
     * \param country Country name.
     * \param city City name.
     * \param street Street name.
     */
    virtual void downloadData(const QString &country = QString(),
                              const QString &city = QString(),
                              const QString &street = QString());

    //! Get the searchLocationData object.
    SearchLocationData *getSearchLocationData() const { return
                                                        searchLocationData; }

private:
    //! The address of the web page used to download data.
    const QString downloadAddress;

    //! String constants used in constructing the remote file path.
    const QString cName1;
    const QString cName2;

    //! Teh downloaded data.
    SearchLocationData *searchLocationData;

private slots:
    //! Reads the downloaded data from the Javascript object.
    virtual void readDataFromJavaScriptObject();

    //! Called in case of a failed download.
    virtual void downloadFailed();
};

#endif
