/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include <QDebug>
#include <QObject>
#include <QWebFrame>
#include "searchlocationdownloader.h"

//! Constructor
SearchLocationDownloader::SearchLocationDownloader(QObject *data,
                                                   QObject *parent) :
    GoogleMapsDownloader(parent),
    downloadAddress("http://qtmapper.garage.maemo.org/locationsearch.html"),
    cName1("ihmekaupunki"),
    cName2("Kemi, Finland")
{
    this->searchLocationData = qobject_cast<SearchLocationData *> (data);

    connect(searchLocationData, SIGNAL(locationDataReady()),
            this, SLOT(readDataFromJavaScriptObject()));
    connect(searchLocationData, SIGNAL(locationSearchError()),
            this, SLOT(downloadFailed()));
}

//! Download data from Google Maps.
void SearchLocationDownloader::downloadData(const QString &country,
                                            const QString &city,
                                            const QString &street)
{
    QString urlString(downloadAddress);
    QString parameters = QString();

    if (!country.isEmpty()) {
        parameters.isEmpty() ? parameters.append("?") : parameters.append("&");
        parameters.append("country=");
        parameters.append(country);
    }

    if (!city.isEmpty()) {
        parameters.isEmpty() ? parameters.append("?") : parameters.append("&");

        parameters.append("city=");

        if (city == cName1) {
            parameters.append(cName2);
        }
        else {
            parameters.append(city);
        }
    }

    if (!street.isEmpty()) {
        parameters.isEmpty() ? parameters.append("?") : parameters.append("&");
        parameters.append("street=");
        parameters.append(street);
    }

    urlString.append(parameters);
    emit readyToDownload(urlString);
}

//! Reads the downloaded data from the Javascript object.
void SearchLocationDownloader::readDataFromJavaScriptObject()
{
    QString script(
    "point = new GLatLng(searchResult.Point.coordinates[1],"
    "                    searchResult.Point.coordinates[0]);"
    "if (searchResult.name != null) {"
    "    var name = new String(searchResult.name);"
    "}"
    "if (searchResult.address != null) {"
    "    var address = new String(searchResult.address);"
    "}"
    "searchLocationData.setLatitude(point.lat());"
    "searchLocationData.setLongitude(point.lng());"
    "searchLocationData.setName(name);"
    "searchLocationData.setAddress(address);"
    );

    mainFrame()->evaluateJavaScript(script);

    emit completed();
}

//! Called in case of a failed download.
void SearchLocationDownloader::downloadFailed()
{
    emit failed();
}
