/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#include "searchlocationdialog.h"

//! Constructor
SearchLocationDialog::SearchLocationDialog(QWidget *parent)
        : QDialog(parent)
{
    setupUi(this);
    pushButton->setEnabled(false);
    
    connect(lineEditCountryName, SIGNAL(textChanged(const QString &)),
            this, SLOT(enableGoToButton()));
    connect(lineEditCityName, SIGNAL(textChanged(const QString &)),
            this, SLOT(enableGoToButton()));
    connect(lineEditStreetName, SIGNAL(textChanged(const QString &)),
            this, SLOT(enableGoToButton()));

    setAttribute(Qt::WA_DeleteOnClose, true);
}

//! Enables the dialog's Goto button.
void SearchLocationDialog::enableGoToButton()
{
    // If all fields are empty, disable the button.
    if (lineEditCountryName->text().isEmpty() &&
            lineEditCityName->text().isEmpty() &&
            lineEditStreetName->text().isEmpty()) {
        pushButton->setEnabled(false);
    } 
    else {
        pushButton->setEnabled(true);
    }
}

//! Destructor
SearchLocationDialog::~SearchLocationDialog()
{
}
