/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef SEARCHLOCATIONDATA_H
#define SEARCHLOCATIONDATA_H
#include <QObject>
#include <QString>

//! Class holds the results of a Google Maps location search.
class SearchLocationData : public QObject
{
    Q_OBJECT

public:
    /*!
     * Constructor.
     *
     * \param parent The parent object.
     */
    SearchLocationData(QObject *parent = 0);

public slots:
    //! Sets name.
    void setName(const QString &name) { this->name = name; }

    //! Returns name.
    QString getName() const { return name; }

    //! Sets address.
    void setAddress(const QString &address) { this->address = address; }

    //! Returns address.
    QString getAddress() const { return address; }

    //! Sets latitude.
    void setLatitude(qreal latitude) { this->latitude = latitude; }

    //! Returns latitude.
    qreal getLatitude() { return latitude; }

    //! Sets longitude.
    void setLongitude(qreal longitude) { this->longitude = longitude; }

    //! Returns longitude.
    qreal getLongitude() { return longitude; }

    //! This is called from the JavaScript code if a search was successful.
    void searchLocationDownloadCompleted();

    //! This is called from the JavaScript code if a search failed.
    void searchLocationDownloadFailed();

private:
    //! Name of this object.
    const QString objectName;

    //! Name of location
    QString name;

    //! Address of location
    QString address;

    //! Latitude of location
    qreal latitude;

    //! Longitude of location
    qreal longitude;

signals:
    //! Emitted when the download is complete.
    void locationDataReady();

    //! Emitted when there was an error downloading.
    void locationSearchError();
};

#endif // SEARCHLOCATIONDATA_H
