/*
    Qt Mapper - A GPS map application
    Copyright (C) 2008  Ixonos Plc. Authors:

        Antero Lehtonen - antero.lehtonen@ixonos.com
        Atte Tihinen - atte.tihinen@ixonos.com
        Jaakko Putaala - jaakko.putaala@ixonos.com
        Teppo Pennanen - teppo.pennanen@ixonos.com

    Qt Mapper is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    Qt Mapper is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Qt Mapper; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/

#ifndef SATELLITEDETAILSDIALOG_H
#define SATELLITEDETAILSDIALOG_H

#include "ui_satellitedetails.h"

class GpsData;
class Point;
class QTime;
class Diagrams;
class QVBoxLayout;

/*!
 * Class SatelliteDetailsDialog creates a dialog
 * that shows selected GPS-information
 */
class SatelliteDetailsDialog : public QDialog, Ui::satelliteDetailsDialog
{

    Q_OBJECT

public:
    /*!
     * Constructor.
     * \param gpsData The used GpsData object
     * \param point The used Point object
     * \param parent This dialog's parent widget
     */
    SatelliteDetailsDialog(GpsData &gpsData, Point &point, QWidget *parent = 0);

    //! destructor
    ~SatelliteDetailsDialog();

public slots:
    /*!
     * for changing the displayed values other than time
     *
     * \param identifier The name of the value to be changed
     * \param value The new value to be displayed
     */
    void changeValue(const QString &identifier, qreal value);

    /*!
     * for changing the displayed time
     *
     * \param systemTime The time to be displayed
     */
    void changeTime(QTime &systemTime);

    /*!
     * for updating the bars that visualize satellites' SNR
     *
     * \param prn ID number of the satellite which bar is to be updated
     * \param snr Satellite's new signal to noise ratio
     */
    void updateBars(int prn, int snr) ;

private slots:
    /*!
     * when user changes tabs, construct or destruct the SNR bars
     *
     * \param index The index of the tab currently displayed
     */
    void tabChanged(int index) ;

private:
    //! Object that handles the SNR bars
    Diagrams* diag;

    //! Layout for the Diagrams object
    QVBoxLayout* vbox;

    //! Names for fix qualities
    QString fixQualityText[9];

    //! Names for 3D fix types
    QString fix3d[3];

    // String constants.
    const QString degreeSign;
    const QString kilometersPerHour;
    const QString meters;
    const QString timeFormat;
};

#endif
